/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access.trx.page;

import io.brackit.query.jdm.DocumentException;
import io.sirix.access.DatabaseType;
import io.sirix.access.ResourceConfiguration;
import io.sirix.access.trx.node.IndexController;
import io.sirix.access.trx.node.InternalResourceSession;
import io.sirix.access.trx.page.NodePageReadOnlyTrx;
import io.sirix.access.trx.page.NodePageTrx;
import io.sirix.access.trx.page.RevisionRootPageReader;
import io.sirix.access.trx.page.TransactionIntentLogFactoryImpl;
import io.sirix.access.trx.page.TreeModifierImpl;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.api.NodeTrx;
import io.sirix.api.PageTrx;
import io.sirix.api.json.JsonResourceSession;
import io.sirix.api.xml.XmlResourceSession;
import io.sirix.cache.BufferManager;
import io.sirix.cache.PageContainer;
import io.sirix.cache.TransactionIntentLog;
import io.sirix.exception.SirixException;
import io.sirix.exception.SirixIOException;
import io.sirix.io.Writer;
import io.sirix.page.CASPage;
import io.sirix.page.DeweyIDPage;
import io.sirix.page.IndirectPage;
import io.sirix.page.PageReference;
import io.sirix.page.PathPage;
import io.sirix.page.PathSummaryPage;
import io.sirix.page.RevisionRootPage;
import io.sirix.page.UberPage;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.inject.Inject;
import org.checkerframework.checker.index.qual.NonNegative;

public final class PageTrxFactory {
    private final DatabaseType databaseType;

    @Inject
    public PageTrxFactory(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PageTrx createPageTrx(InternalResourceSession<? extends NodeReadOnlyTrx, ? extends NodeTrx> resourceManager, UberPage uberPage, Writer writer, @NonNegative long trxId, @NonNegative int representRevision, @NonNegative int lastStoredRevision, @NonNegative int lastCommitedRevision, boolean isBoundToNodeTrx, BufferManager bufferManager) {
        ResourceConfiguration resourceConfig = resourceManager.getResourceConfig();
        boolean usePathSummary = resourceConfig.withPathSummary;
        Object indexController = resourceManager.getWtxIndexController(representRevision);
        Path indexes = resourceConfig.resourcePath.resolve(ResourceConfiguration.ResourcePaths.INDEXES.getPath()).resolve(lastStoredRevision + ".xml");
        if (Files.exists(indexes, new LinkOption[0])) {
            try (FileInputStream in = new FileInputStream(indexes.toFile());){
                indexController.getIndexes().init(IndexController.deserialize(in).getFirstChild());
            }
            catch (DocumentException | SirixException | IOException e) {
                throw new SirixIOException("Index definitions couldn't be deserialized!", e);
            }
        }
        TreeModifierImpl treeModifier = new TreeModifierImpl();
        TransactionIntentLogFactoryImpl logFactory = new TransactionIntentLogFactoryImpl();
        TransactionIntentLog log = logFactory.createTrxIntentLog(resourceConfig);
        if (uberPage.isBootstrap()) {
            uberPage.createRevisionTree(log);
        }
        NodePageReadOnlyTrx pageRtx = new NodePageReadOnlyTrx(trxId, resourceManager, uberPage, representRevision, writer, bufferManager, new RevisionRootPageReader(), log);
        RevisionRootPage lastCommitedRoot = pageRtx.loadRevRoot(lastCommitedRevision);
        RevisionRootPage newRevisionRootPage = treeModifier.preparePreviousRevisionRootPage(uberPage, pageRtx, log, representRevision, lastStoredRevision);
        newRevisionRootPage.setMaxNodeKeyInDocumentIndex(lastCommitedRoot.getMaxNodeKeyInDocumentIndex());
        newRevisionRootPage.setMaxNodeKeyInInChangedNodesIndex(lastCommitedRoot.getMaxNodeKeyInChangedNodesIndex());
        if (resourceConfig.storeNodeHistory()) {
            newRevisionRootPage.setMaxNodeKeyInRecordToRevisionsIndex(lastCommitedRoot.getMaxNodeKeyInRecordToRevisionsIndex());
        }
        newRevisionRootPage.createDocumentIndexTree(this.databaseType, pageRtx, log);
        newRevisionRootPage.createChangedNodesIndexTree(this.databaseType, pageRtx, log);
        if (resourceConfig.storeNodeHistory()) {
            newRevisionRootPage.createRecordToRevisionsIndexTree(this.databaseType, pageRtx, log);
        }
        if (usePathSummary) {
            PathSummaryPage page = pageRtx.getPathSummaryPage(newRevisionRootPage);
            page.createPathSummaryTree(this.databaseType, pageRtx, 0, log);
            if (log.get(newRevisionRootPage.getPathSummaryPageReference()) == null) {
                log.put(newRevisionRootPage.getPathSummaryPageReference(), PageContainer.getInstance(page, page));
            }
        }
        if (uberPage.isBootstrap()) {
            namePage = pageRtx.getNamePage(newRevisionRootPage);
            DeweyIDPage deweyIDPage = pageRtx.getDeweyIDPage(newRevisionRootPage);
            if (resourceManager instanceof JsonResourceSession) {
                namePage.createNameIndexTree(this.databaseType, pageRtx, 0, log);
                deweyIDPage.createIndexTree(this.databaseType, pageRtx, log);
                return new NodePageTrx(treeModifier, writer, log, newRevisionRootPage, pageRtx, (IndexController<?, ?>)indexController, representRevision, isBoundToNodeTrx);
            } else {
                if (!(resourceManager instanceof XmlResourceSession)) throw new IllegalStateException("Resource manager type not known.");
                namePage.createNameIndexTree(this.databaseType, pageRtx, 0, log);
                namePage.createNameIndexTree(this.databaseType, pageRtx, 1, log);
                namePage.createNameIndexTree(this.databaseType, pageRtx, 2, log);
                namePage.createNameIndexTree(this.databaseType, pageRtx, 3, log);
                deweyIDPage.createIndexTree(this.databaseType, pageRtx, log);
            }
            return new NodePageTrx(treeModifier, writer, log, newRevisionRootPage, pageRtx, (IndexController<?, ?>)indexController, representRevision, isBoundToNodeTrx);
        } else {
            if (log.get(newRevisionRootPage.getNamePageReference()) == null) {
                namePage = pageRtx.getNamePage(newRevisionRootPage);
                log.put(newRevisionRootPage.getNamePageReference(), PageContainer.getInstance(namePage, namePage));
            }
            if (log.get(newRevisionRootPage.getCASPageReference()) == null) {
                CASPage casPage = pageRtx.getCASPage(newRevisionRootPage);
                log.put(newRevisionRootPage.getCASPageReference(), PageContainer.getInstance(casPage, casPage));
            }
            if (log.get(newRevisionRootPage.getPathPageReference()) == null) {
                PathPage pathPage = pageRtx.getPathPage(newRevisionRootPage);
                log.put(newRevisionRootPage.getPathPageReference(), PageContainer.getInstance(pathPage, pathPage));
            }
            if (log.get(newRevisionRootPage.getDeweyIdPageReference()) == null) {
                DeweyIDPage deweyIDPage = pageRtx.getDeweyIDPage(newRevisionRootPage);
                log.put(newRevisionRootPage.getDeweyIdPageReference(), PageContainer.getInstance(deweyIDPage, deweyIDPage));
            }
            IndirectPage indirectPage = pageRtx.dereferenceIndirectPageReference(newRevisionRootPage.getIndirectDocumentIndexPageReference());
            log.put(newRevisionRootPage.getIndirectDocumentIndexPageReference(), PageContainer.getInstance(indirectPage, indirectPage));
            PageReference revisionRootPageReference = new PageReference();
            log.put(revisionRootPageReference, PageContainer.getInstance(newRevisionRootPage, newRevisionRootPage));
            uberPage.setRevisionRootPageReference(revisionRootPageReference);
            uberPage.setRevisionRootPage(newRevisionRootPage);
        }
        return new NodePageTrx(treeModifier, writer, log, newRevisionRootPage, pageRtx, (IndexController<?, ?>)indexController, representRevision, isBoundToNodeTrx);
    }
}

