/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access.trx.page;

import io.sirix.access.trx.page.NodePageReadOnlyTrx;
import io.sirix.access.trx.page.TreeModifier;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.cache.PageContainer;
import io.sirix.cache.TransactionIntentLog;
import io.sirix.index.IndexType;
import io.sirix.page.IndirectPage;
import io.sirix.page.PageReference;
import io.sirix.page.RevisionRootPage;
import io.sirix.page.UberPage;
import org.checkerframework.checker.index.qual.NonNegative;

public final class TreeModifierImpl
implements TreeModifier {
    TreeModifierImpl() {
    }

    @Override
    public RevisionRootPage preparePreviousRevisionRootPage(UberPage uberPage, NodePageReadOnlyTrx pageRtx, TransactionIntentLog log, @NonNegative int baseRevision, @NonNegative int representRevision) {
        RevisionRootPage revisionRootPage;
        if (uberPage.isBootstrap()) {
            revisionRootPage = pageRtx.loadRevRoot(baseRevision);
        } else {
            revisionRootPage = new RevisionRootPage(pageRtx.loadRevRoot(baseRevision), representRevision + 1);
            log.put(new PageReference(), PageContainer.getInstance(revisionRootPage, revisionRootPage));
        }
        return revisionRootPage;
    }

    @Override
    public PageReference prepareLeafOfTree(PageReadOnlyTrx pageRtx, TransactionIntentLog log, int[] inpLevelPageCountExp, PageReference startReference, @NonNegative long pageKey, int index, IndexType indexType, RevisionRootPage revisionRootPage) {
        PageReference reference = startReference;
        long levelKey = pageKey;
        int maxHeight = pageRtx.getCurrentMaxIndirectPageTreeLevel(indexType, index, revisionRootPage);
        if (pageKey == 1L << inpLevelPageCountExp[inpLevelPageCountExp.length - maxHeight - 1]) {
            maxHeight = this.incrementCurrentMaxIndirectPageTreeLevel(pageRtx, revisionRootPage, indexType, index);
            IndirectPage oldPage = this.dereferenceOldIndirectPage(pageRtx, log, reference);
            IndirectPage page = new IndirectPage();
            PageReference newReference = page.getOrCreateReference(0);
            log.put(newReference, PageContainer.getInstance(oldPage, oldPage));
            PageReference newPageReference = new PageReference();
            log.put(newPageReference, PageContainer.getInstance(page, page));
            this.setNewIndirectPage(pageRtx, revisionRootPage, indexType, index, newPageReference);
            reference = newPageReference;
        }
        int height = inpLevelPageCountExp.length;
        for (int level = inpLevelPageCountExp.length - maxHeight; level < height; ++level) {
            int offset = (int)(levelKey >> inpLevelPageCountExp[level]);
            levelKey -= (long)offset << inpLevelPageCountExp[level];
            IndirectPage page = this.prepareIndirectPage(pageRtx, log, reference);
            reference = page.getOrCreateReference(offset);
        }
        return reference;
    }

    private IndirectPage dereferenceOldIndirectPage(PageReadOnlyTrx pageRtx, TransactionIntentLog log, PageReference reference) throws AssertionError {
        IndirectPage oldPage;
        PageContainer cont = log.get(reference);
        IndirectPage indirectPage = oldPage = cont == null ? null : (IndirectPage)cont.getComplete();
        if (oldPage == null) {
            if (reference.getKey() == -15L) {
                throw new AssertionError((Object)"The referenced page on top must of our tree must exist (first IndirectPage).");
            }
            IndirectPage indirectPage2 = pageRtx.dereferenceIndirectPageReference(reference);
            oldPage = new IndirectPage(indirectPage2);
        }
        return oldPage;
    }

    private void setNewIndirectPage(PageReadOnlyTrx pageRtx, RevisionRootPage revisionRoot, IndexType indexType, int index, PageReference pageReference) {
        switch (indexType) {
            case DOCUMENT: {
                revisionRoot.setOrCreateReference(0, pageReference);
                break;
            }
            case CHANGED_NODES: {
                revisionRoot.setOrCreateReference(1, pageReference);
                break;
            }
            case RECORD_TO_REVISIONS: {
                revisionRoot.setOrCreateReference(2, pageReference);
                break;
            }
            case CAS: {
                pageRtx.getCASPage(revisionRoot).setOrCreateReference(index, pageReference);
                break;
            }
            case PATH: {
                pageRtx.getPathPage(revisionRoot).setOrCreateReference(index, pageReference);
                break;
            }
            case NAME: {
                pageRtx.getNamePage(revisionRoot).setOrCreateReference(index, pageReference);
                break;
            }
            case PATH_SUMMARY: {
                pageRtx.getPathSummaryPage(revisionRoot).setOrCreateReference(index, pageReference);
                break;
            }
            default: {
                throw new IllegalStateException("Only defined for node, path summary, text value and attribute value pages!");
            }
        }
    }

    private int incrementCurrentMaxIndirectPageTreeLevel(PageReadOnlyTrx pageRtx, RevisionRootPage revisionRoot, IndexType indexType, int index) {
        return switch (indexType) {
            case IndexType.DOCUMENT -> revisionRoot.incrementAndGetCurrentMaxLevelOfDocumentIndexIndirectPages();
            case IndexType.CHANGED_NODES -> revisionRoot.incrementAndGetCurrentMaxLevelOfChangedNodesIndexIndirectPages();
            case IndexType.RECORD_TO_REVISIONS -> revisionRoot.incrementAndGetCurrentMaxLevelOfRecordToRevisionsIndexIndirectPages();
            case IndexType.CAS -> pageRtx.getCASPage(revisionRoot).incrementAndGetCurrentMaxLevelOfIndirectPages(index);
            case IndexType.PATH -> pageRtx.getPathPage(revisionRoot).incrementAndGetCurrentMaxLevelOfIndirectPages(index);
            case IndexType.NAME -> pageRtx.getNamePage(revisionRoot).incrementAndGetCurrentMaxLevelOfIndirectPages(index);
            case IndexType.PATH_SUMMARY -> pageRtx.getPathSummaryPage(revisionRoot).incrementAndGetCurrentMaxLevelOfIndirectPages(index);
            default -> throw new IllegalStateException("Only defined for node, path summary, text value and attribute value pages!");
        };
    }

    @Override
    public IndirectPage prepareIndirectPage(PageReadOnlyTrx pageRtx, TransactionIntentLog log, PageReference reference) {
        IndirectPage page;
        PageContainer cont = log.get(reference);
        IndirectPage indirectPage = page = cont == null ? null : (IndirectPage)cont.getComplete();
        if (page == null) {
            if (reference.getKey() == -15L) {
                page = new IndirectPage();
            } else {
                IndirectPage indirectPage2 = pageRtx.dereferenceIndirectPageReference(reference);
                page = new IndirectPage(indirectPage2);
            }
            log.put(reference, PageContainer.getInstance(page, page));
        }
        return page;
    }
}

