/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.api;

import io.sirix.access.ResourceConfiguration;
import io.sirix.access.User;
import io.sirix.access.trx.node.AfterCommitState;
import io.sirix.access.trx.node.IndexController;
import io.sirix.api.NodeCursor;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.api.NodeTrx;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.api.PageTrx;
import io.sirix.api.RevisionInfo;
import io.sirix.cache.Cache;
import io.sirix.cache.RBIndexKey;
import io.sirix.index.path.summary.PathSummaryReader;
import io.sirix.node.interfaces.Node;
import java.nio.file.Path;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface ResourceSession<R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor>
extends AutoCloseable {
    public Path getResourcePath();

    public List<RevisionInfo> getHistory();

    public List<RevisionInfo> getHistory(int var1);

    public List<RevisionInfo> getHistory(int var1, int var2);

    public Optional<W> getNodeTrx();

    default public PageReadOnlyTrx beginPageReadOnlyTrx() {
        return this.beginPageReadOnlyTrx(this.getMostRecentRevisionNumber());
    }

    public PageReadOnlyTrx beginPageReadOnlyTrx(@NonNegative int var1);

    default public PageTrx beginPageTrx() {
        return this.beginPageTrx(this.getMostRecentRevisionNumber());
    }

    public PageTrx beginPageTrx(@NonNegative int var1);

    default public R beginNodeReadOnlyTrx() {
        return this.beginNodeReadOnlyTrx(this.getMostRecentRevisionNumber());
    }

    public R beginNodeReadOnlyTrx(@NonNegative int var1);

    public R beginNodeReadOnlyTrx(@NonNull Instant var1);

    public W beginNodeTrx(@NonNull AfterCommitState var1);

    public W beginNodeTrx(@NonNegative int var1, @NonNull AfterCommitState var2);

    public W beginNodeTrx(@NonNegative int var1, @NonNull TimeUnit var2, @NonNull AfterCommitState var3);

    public W beginNodeTrx(@NonNegative int var1, @NonNegative int var2, @NonNull TimeUnit var3, @NonNull AfterCommitState var4);

    public W beginNodeTrx();

    public W beginNodeTrx(@NonNegative int var1);

    public W beginNodeTrx(@NonNegative int var1, @NonNull TimeUnit var2);

    public W beginNodeTrx(@NonNegative int var1, @NonNegative int var2, @NonNull TimeUnit var3);

    public PathSummaryReader openPathSummary(@NonNegative int var1);

    default public PathSummaryReader openPathSummary() {
        return this.openPathSummary(this.getMostRecentRevisionNumber());
    }

    public int getRevisionNumber(@NonNull Instant var1);

    @Override
    public void close();

    public boolean isClosed();

    public int getMostRecentRevisionNumber();

    public ResourceConfiguration getResourceConfig();

    public <C extends IndexController<R, W>> C getRtxIndexController(int var1);

    public <C extends IndexController<R, W>> C getWtxIndexController(int var1);

    public Optional<R> getNodeReadTrxByTrxId(Long var1);

    public boolean hasRunningNodeWriteTrx();

    public Optional<User> getUser();

    public Cache<RBIndexKey, Node> getIndexCache();
}

