/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.sirix.api.Axis;
import io.sirix.api.NodeCursor;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.api.json.JsonNodeReadOnlyTrx;
import io.sirix.api.visitor.XmlNodeVisitor;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.axis.IncludeSelf;
import io.sirix.index.path.summary.PathSummaryReader;
import io.sirix.settings.Fixed;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.checkerframework.checker.index.qual.NonNegative;

public abstract class AbstractAxis
implements Axis {
    protected final NodeCursor nodeCursor;
    private long nextNodeKey;
    private long startNodeKey;
    private final IncludeSelf includeSelf;
    private State state = State.NOT_READY;

    public AbstractAxis(NodeCursor nodeCursor) {
        this.nodeCursor = Objects.requireNonNull(nodeCursor);
        this.includeSelf = IncludeSelf.NO;
        this.reset(nodeCursor.getNodeKey());
    }

    public AbstractAxis(NodeCursor nodeCursor, IncludeSelf includeSelf) {
        this.nodeCursor = Objects.requireNonNull(nodeCursor);
        this.includeSelf = Objects.requireNonNull(includeSelf);
        this.reset(nodeCursor.getNodeKey());
    }

    public final LongIterator iterator() {
        return this;
    }

    protected long done() {
        return Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    public final boolean hasNext() {
        Preconditions.checkState((this.state != State.FAILED ? 1 : 0) != 0);
        switch (this.state.ordinal()) {
            case 2: {
                return false;
            }
            case 0: {
                return true;
            }
        }
        this.resetToLastKey();
        boolean hasNext = this.tryToComputeNext();
        if (hasNext) {
            return true;
        }
        this.resetToStartKey();
        return false;
    }

    private boolean tryToComputeNext() {
        this.state = State.FAILED;
        this.nextNodeKey = this.nextKey();
        if (this.nextNodeKey == Fixed.NULL_NODE_KEY.getStandardProperty()) {
            this.state = State.DONE;
        }
        if (this.state == State.DONE) {
            return false;
        }
        this.state = State.READY;
        return true;
    }

    protected abstract long nextKey();

    public final long nextLong() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.NOT_READY;
        if (this.nextNodeKey >= 0L) {
            if (!this.nodeCursor.moveTo(this.nextNodeKey)) {
                throw new IllegalStateException("Failed to move to nodeKey: " + this.nextNodeKey);
            }
        } else {
            this.nodeCursor.moveTo(this.nextNodeKey);
        }
        return this.nextNodeKey;
    }

    public final void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset(@NonNegative long nodeKey) {
        this.startNodeKey = nodeKey;
        this.nextNodeKey = nodeKey;
        this.state = State.NOT_READY;
    }

    @Override
    public XmlNodeReadOnlyTrx asXmlNodeReadTrx() {
        if (this.nodeCursor instanceof XmlNodeReadOnlyTrx) {
            return (XmlNodeReadOnlyTrx)this.nodeCursor;
        }
        throw new ClassCastException("Node cursor is no XDM node transaction.");
    }

    @Override
    public JsonNodeReadOnlyTrx asJsonNodeReadTrx() {
        if (this.nodeCursor instanceof JsonNodeReadOnlyTrx) {
            return (JsonNodeReadOnlyTrx)this.nodeCursor;
        }
        throw new ClassCastException("Node cursor is no JSON node transaction.");
    }

    @Override
    public PathSummaryReader asPathSummary() {
        if (this.nodeCursor instanceof PathSummaryReader) {
            return (PathSummaryReader)this.nodeCursor;
        }
        throw new ClassCastException("Node cursor is no path summary reader.");
    }

    @Override
    public NodeCursor getCursor() {
        return this.nodeCursor;
    }

    public NodeReadOnlyTrx getTrx() {
        if (this.nodeCursor instanceof NodeReadOnlyTrx) {
            return (NodeReadOnlyTrx)((Object)this.nodeCursor);
        }
        throw new ClassCastException("Node cursor is no transactional cursor.");
    }

    private long resetToStartKey() {
        this.nodeCursor.moveTo(this.startNodeKey);
        return this.startNodeKey;
    }

    protected final long resetToLastKey() {
        if (this.nodeCursor.getNodeKey() != this.nextNodeKey) {
            this.nodeCursor.moveTo(this.nextNodeKey);
        }
        return this.nextNodeKey;
    }

    @Override
    public final long peek() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.nextNodeKey;
    }

    @Override
    public final long getStartKey() {
        return this.startNodeKey;
    }

    @Override
    public final IncludeSelf includeSelf() {
        return this.includeSelf;
    }

    @Override
    public final void foreach(XmlNodeVisitor visitor) {
        Objects.requireNonNull(visitor);
        if (this.nodeCursor instanceof XmlNodeReadOnlyTrx) {
            while (this.hasNext()) {
                this.nextLong();
                ((XmlNodeReadOnlyTrx)this.nodeCursor).acceptVisitor(visitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized long nextNode() {
        NodeCursor nodeCursor = this.nodeCursor;
        synchronized (nodeCursor) {
            long retVal = Fixed.NULL_NODE_KEY.getStandardProperty();
            if (this.hasNext()) {
                retVal = this.nextLong();
            }
            return retVal;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("trx", (Object)this.nodeCursor).toString();
    }

    private static enum State {
        READY,
        NOT_READY,
        DONE,
        FAILED;

    }
}

