/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis;

import io.sirix.api.NodeCursor;
import io.sirix.axis.AbstractAxis;
import io.sirix.axis.IncludeSelf;
import io.sirix.utils.Pair;
import java.util.ArrayDeque;
import java.util.Deque;

public final class JsonDescendantAxis
extends AbstractAxis {
    private Deque<Pair<Long, Integer>> rightSiblingKeyStack;
    private boolean first;
    private int depth;

    public JsonDescendantAxis(NodeCursor cursor) {
        super(cursor);
    }

    public JsonDescendantAxis(NodeCursor cursor, IncludeSelf includeSelf) {
        super(cursor, includeSelf);
    }

    @Override
    public void reset(long nodeKey) {
        super.reset(nodeKey);
        this.first = true;
        this.rightSiblingKeyStack = new ArrayDeque<Pair<Long, Integer>>();
    }

    @Override
    protected long nextKey() {
        NodeCursor cursor = this.getCursor();
        if (this.first) {
            long key;
            this.first = false;
            if (this.includeSelf() == IncludeSelf.YES) {
                key = cursor.getNodeKey();
            } else {
                key = cursor.getFirstChildKey();
                ++this.depth;
            }
            return key;
        }
        if (cursor.hasFirstChild()) {
            long key = cursor.getFirstChildKey();
            if (cursor.hasRightSibling()) {
                this.rightSiblingKeyStack.push(new Pair<Long, Integer>(cursor.getRightSiblingKey(), this.depth));
            }
            ++this.depth;
            return key;
        }
        if (cursor.hasRightSibling()) {
            long key = cursor.getRightSiblingKey();
            if (this.depth == 0) {
                return this.done();
            }
            return key;
        }
        if (this.rightSiblingKeyStack.size() > 0) {
            Pair<Long, Integer> pair = this.rightSiblingKeyStack.pop();
            long key = pair.getFirst();
            this.depth = pair.getSecond();
            if (this.depth == 0) {
                return this.done();
            }
            return key;
        }
        return this.done();
    }
}

