/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis;

import com.google.common.base.Preconditions;
import io.sirix.api.NodeCursor;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.axis.AbstractAxis;
import io.sirix.axis.IncludeSelf;
import io.sirix.node.NodeKind;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.Objects;
import org.checkerframework.checker.index.qual.NonNegative;

public final class LevelOrderAxis
extends AbstractAxis {
    private LongArrayList firstChilds;
    private final IncludeNodes includeNodes;
    private boolean isFirst;
    private int filterLevel = Integer.MAX_VALUE;
    private int level;

    public static Builder newBuilder(NodeCursor rtx) {
        return new Builder(rtx);
    }

    private LevelOrderAxis(Builder builder) {
        super(builder.mRtx, builder.includeSelf);
        this.includeNodes = builder.includeNodes;
        this.filterLevel = builder.filterLevel;
    }

    @Override
    public void reset(long pNodeKey) {
        super.reset(pNodeKey);
        this.isFirst = true;
        this.firstChilds = new LongArrayList();
    }

    @Override
    protected long nextKey() {
        NodeCursor cursor = this.getCursor();
        if (this.isFirst) {
            this.isFirst = false;
            if (cursor.getKind() == NodeKind.ATTRIBUTE || cursor.getKind() == NodeKind.NAMESPACE) {
                return this.done();
            }
            if (this.includeSelf() == IncludeSelf.YES) {
                return cursor.getNodeKey();
            }
            if (cursor.hasRightSibling()) {
                return cursor.getRightSiblingKey();
            }
            if (cursor.hasFirstChild()) {
                return cursor.getFirstChildKey();
            }
            return this.done();
        }
        if (cursor.hasRightSibling()) {
            this.processElement();
            if (cursor.hasFirstChild()) {
                this.firstChilds.add(cursor.getFirstChildKey());
            }
            return cursor.getRightSiblingKey();
        }
        this.processElement();
        if (cursor.hasFirstChild()) {
            this.firstChilds.add(cursor.getFirstChildKey());
        }
        if (!this.firstChilds.isEmpty()) {
            ++this.level;
            if (this.level > this.filterLevel) {
                return this.done();
            }
            return this.firstChilds.removeLong(0);
        }
        if (cursor.hasFirstChild()) {
            ++this.level;
            if (this.level > this.filterLevel) {
                return this.done();
            }
            return cursor.getFirstChildKey();
        }
        return this.done();
    }

    public int getCurrentLevel() {
        return this.level;
    }

    private void processElement() {
        XmlNodeReadOnlyTrx rtx;
        if (this.getCursor() instanceof XmlNodeReadOnlyTrx && (rtx = this.asXmlNodeReadTrx()).getKind() == NodeKind.ELEMENT && this.includeNodes == IncludeNodes.NONSTRUCTURAL) {
            int i;
            int nspCount = rtx.getNamespaceCount();
            for (i = 0; i < nspCount; ++i) {
                rtx.moveToNamespace(i);
                this.firstChilds.add(rtx.getNodeKey());
                rtx.moveToParent();
            }
            int attCount = rtx.getAttributeCount();
            for (i = 0; i < attCount; ++i) {
                rtx.moveToAttribute(i);
                this.firstChilds.add(rtx.getNodeKey());
                rtx.moveToParent();
            }
        }
    }

    public static class Builder {
        private IncludeNodes includeNodes = IncludeNodes.STRUCTURAL;
        private int filterLevel = Integer.MAX_VALUE;
        private final NodeCursor mRtx;
        private IncludeSelf includeSelf = IncludeSelf.NO;

        public Builder(NodeCursor rtx) {
            this.mRtx = Objects.requireNonNull(rtx);
        }

        public Builder includeNonStructuralNodes() {
            this.includeNodes = IncludeNodes.NONSTRUCTURAL;
            return this;
        }

        public Builder includeSelf() {
            this.includeSelf = IncludeSelf.YES;
            return this;
        }

        public Builder filterLevel(@NonNegative int filterLevel) {
            Preconditions.checkArgument((filterLevel >= 0 ? 1 : 0) != 0, (Object)"filterLevel must be >= 0!");
            this.filterLevel = filterLevel;
            return this;
        }

        public LevelOrderAxis build() {
            return new LevelOrderAxis(this);
        }
    }

    private static enum IncludeNodes {
        STRUCTURAL,
        NONSTRUCTURAL;

    }
}

