/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis;

import io.sirix.api.Axis;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.axis.AbstractAxis;
import io.sirix.axis.IncludeSelf;
import io.sirix.settings.Fixed;
import java.util.Objects;

public final class NonStructuralWrapperAxis
extends AbstractAxis {
    private final Axis mParentAxis;
    private int mNspIndex;
    private int mAttIndex;
    private boolean mFirst;

    public NonStructuralWrapperAxis(Axis parentAxis) {
        super(parentAxis.asXmlNodeReadTrx());
        this.mParentAxis = Objects.requireNonNull(parentAxis);
    }

    @Override
    public void reset(long nodeKey) {
        super.reset(nodeKey);
        if (this.mParentAxis != null) {
            this.mParentAxis.reset(nodeKey);
        }
        this.mNspIndex = 0;
        this.mAttIndex = 0;
        this.mFirst = true;
    }

    @Override
    protected long nextKey() {
        long nodeKey;
        XmlNodeReadOnlyTrx trx = this.mParentAxis.asXmlNodeReadTrx();
        if (!(this.mParentAxis.includeSelf() != IncludeSelf.NO && this.mFirst || (nodeKey = this.nonStructural(trx)) == Fixed.NULL_NODE_KEY.getStandardProperty())) {
            return nodeKey;
        }
        if (this.mParentAxis.hasNext()) {
            long key = this.mParentAxis.next();
            this.mFirst = false;
            this.mNspIndex = 0;
            this.mAttIndex = 0;
            return key;
        }
        return this.done();
    }

    private long nonStructural(XmlNodeReadOnlyTrx trx) {
        if (trx.isNamespace()) {
            trx.moveToParent();
        }
        if (trx.isElement() && this.mNspIndex < trx.getNamespaceCount()) {
            trx.moveToNamespace(this.mNspIndex++);
            return trx.getNodeKey();
        }
        if (trx.isAttribute()) {
            trx.moveToParent();
        }
        if (trx.isElement() && this.mAttIndex < trx.getAttributeCount()) {
            trx.moveToAttribute(this.mAttIndex++);
            return trx.getNodeKey();
        }
        return Fixed.NULL_NODE_KEY.getStandardProperty();
    }
}

