/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis;

import io.sirix.api.NodeCursor;
import io.sirix.axis.AbstractAxis;
import io.sirix.axis.IncludeSelf;
import io.sirix.settings.Fixed;

public final class PostOrderAxis
extends AbstractAxis {
    private boolean movedToParent;
    private boolean isStartKey;

    public PostOrderAxis(NodeCursor cursor) {
        super(cursor);
    }

    public PostOrderAxis(NodeCursor cursor, IncludeSelf includeSelf) {
        super(cursor, includeSelf);
    }

    @Override
    public void reset(long nodeKey) {
        super.reset(nodeKey);
        this.movedToParent = false;
        this.isStartKey = false;
    }

    @Override
    protected long nextKey() {
        NodeCursor cursor = this.getCursor();
        if (!cursor.hasFirstChild() && cursor.getNodeKey() == this.getStartKey() || this.isStartKey) {
            if (!this.isStartKey && this.includeSelf() == IncludeSelf.YES) {
                this.isStartKey = true;
                return cursor.getNodeKey();
            }
            return this.done();
        }
        long currKey = cursor.getNodeKey();
        if (!this.movedToParent && cursor.hasFirstChild() || cursor.hasRightSibling() && cursor.moveToRightSibling()) {
            while (cursor.hasFirstChild()) {
                cursor.moveToFirstChild();
            }
            long key = cursor.getNodeKey();
            cursor.moveTo(currKey);
            return key;
        }
        long key = 0L;
        if (cursor.hasRightSibling()) {
            key = cursor.getRightSiblingKey();
        } else {
            key = cursor.getParentKey();
            this.movedToParent = true;
        }
        if (key == Fixed.NULL_NODE_KEY.getStandardProperty()) {
            return key;
        }
        if (key == this.getStartKey()) {
            if (this.includeSelf() == IncludeSelf.YES) {
                this.isStartKey = true;
                return key;
            }
            return this.done();
        }
        cursor.moveTo(currKey);
        return key;
    }
}

