/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis.concurrent;

import io.sirix.api.Axis;
import io.sirix.api.NodeCursor;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.axis.AbstractAxis;
import io.sirix.axis.concurrent.ConcurrentAxisHelper;
import io.sirix.settings.Fixed;
import io.sirix.utils.LogWrapper;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.index.qual.NonNegative;
import org.slf4j.LoggerFactory;

public final class ConcurrentAxis<R extends NodeCursor & NodeReadOnlyTrx>
extends AbstractAxis {
    private static final LogWrapper LOGGER = new LogWrapper(LoggerFactory.getLogger(ConcurrentAxis.class));
    private final Axis producer;
    private final BlockingQueue<Long> results;
    private final int M_CAPACITY = 200;
    private volatile boolean first;
    private volatile Runnable task;
    private volatile boolean finished;
    public volatile ExecutorService executorService;

    public ConcurrentAxis(R rtx, Axis childAxis) {
        super((NodeCursor)rtx);
        if (rtx == childAxis.getTrx()) {
            throw new IllegalArgumentException("The filter must be bound to another transaction but on the same revision/node!");
        }
        this.results = new ArrayBlockingQueue<Long>(200);
        this.first = true;
        this.producer = Objects.requireNonNull(childAxis);
        this.task = new ConcurrentAxisHelper(this.producer, this.results);
        this.executorService = Executors.newSingleThreadExecutor();
        this.finished = false;
    }

    @Override
    public synchronized void reset(@NonNegative long nodeKey) {
        super.reset(nodeKey);
        this.first = true;
        this.finished = false;
        if (this.executorService != null) {
            this.executorService = Executors.newSingleThreadExecutor();
        }
        if (this.producer != null) {
            this.producer.reset(nodeKey);
        }
        if (this.results != null) {
            this.results.clear();
        }
        if (this.task != null) {
            this.task = new ConcurrentAxisHelper(this.producer, this.results);
        }
    }

    @Override
    protected synchronized long nextKey() {
        if (this.first) {
            this.first = false;
            this.executorService.submit(this.task);
        }
        if (this.finished) {
            return this.done();
        }
        long result = Fixed.NULL_NODE_KEY.getStandardProperty();
        try {
            result = this.results.take();
        }
        catch (InterruptedException e) {
            LOGGER.warn(e.getMessage(), e);
        }
        if (result != Fixed.NULL_NODE_KEY.getStandardProperty()) {
            return result;
        }
        this.finished = true;
        return this.done();
    }

    @Override
    protected synchronized long done() {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.warn(e.getMessage(), e);
        }
        return Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    public boolean isFinished() {
        return this.finished;
    }
}

