/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis.concurrent;

import io.sirix.api.Axis;
import io.sirix.api.NodeCursor;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.axis.AbstractAxis;
import io.sirix.axis.concurrent.ConcurrentAxis;
import io.sirix.axis.concurrent.Util;
import io.sirix.service.xml.xpath.EXPathError;

public final class ConcurrentUnionAxis<R extends NodeCursor & NodeReadOnlyTrx>
extends AbstractAxis {
    private final ConcurrentAxis<R> op1;
    private final ConcurrentAxis<R> op2;
    private boolean first;
    private long currentResult1;
    private long currentResult2;

    public ConcurrentUnionAxis(R rtx, Axis operand1, Axis operand2) {
        super((NodeCursor)rtx);
        if (operand1.getCursor() == operand2.getCursor()) {
            throw new IllegalStateException("Operand axis trx must be different.");
        }
        this.op1 = new ConcurrentAxis<R>(rtx, operand1);
        this.op2 = new ConcurrentAxis<R>(rtx, operand2);
        this.first = true;
    }

    @Override
    public void reset(long nodeKey) {
        super.reset(nodeKey);
        if (this.op1 != null) {
            this.op1.reset(nodeKey);
        }
        if (this.op2 != null) {
            this.op2.reset(nodeKey);
        }
        this.first = true;
    }

    @Override
    protected long nextKey() {
        if (this.first) {
            this.first = false;
            this.currentResult1 = Util.getNext(this.op1);
            this.currentResult2 = Util.getNext(this.op2);
        }
        if (!this.op1.isFinished()) {
            if (!this.op2.isFinished()) {
                long nodeKey;
                if (this.currentResult1 < this.currentResult2) {
                    nodeKey = this.currentResult1;
                    this.currentResult1 = Util.getNext(this.op1);
                } else if (this.currentResult1 > this.currentResult2) {
                    nodeKey = this.currentResult2;
                    this.currentResult2 = Util.getNext(this.op2);
                } else {
                    nodeKey = this.currentResult2;
                    this.currentResult1 = Util.getNext(this.op1);
                    this.currentResult2 = Util.getNext(this.op2);
                }
                if (nodeKey < 0L) {
                    throw EXPathError.XPTY0004.getEncapsulatedException();
                }
                return nodeKey;
            }
            long nodeKey = this.currentResult1;
            if (Util.isValid(nodeKey)) {
                this.currentResult1 = Util.getNext(this.op1);
                return nodeKey;
            }
            throw new IllegalStateException(nodeKey + " is not valid!");
        }
        if (!this.op2.isFinished()) {
            long nodeKey = this.currentResult2;
            if (Util.isValid(nodeKey)) {
                this.currentResult2 = Util.getNext(this.op2);
                return nodeKey;
            }
            throw new IllegalStateException(nodeKey + " is not valid!");
        }
        return this.done();
    }
}

