/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis.filter;

import io.sirix.api.Axis;
import io.sirix.api.NodeCursor;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.axis.AbstractAxis;
import java.util.Objects;

public final class PredicateFilterAxis
extends AbstractAxis {
    private boolean isFirst = true;
    private final Axis predicate;

    public PredicateFilterAxis(NodeCursor nodeCursor, Axis predicate) {
        super(nodeCursor);
        this.predicate = Objects.requireNonNull(predicate);
    }

    @Override
    public final void reset(long nodeKey) {
        super.reset(nodeKey);
        if (this.predicate != null) {
            this.predicate.reset(nodeKey);
        }
        this.isFirst = true;
    }

    @Override
    protected long nextKey() {
        if (this.isFirst) {
            this.isFirst = false;
            long currKey = this.getCursor().getNodeKey();
            this.predicate.reset(currKey);
            if (this.predicate.hasNext()) {
                this.predicate.next();
                if (this.isBooleanFalse()) {
                    return this.done();
                }
                return currKey;
            }
        }
        return this.done();
    }

    private boolean isBooleanFalse() {
        if (this.getTrx() instanceof XmlNodeReadOnlyTrx) {
            XmlNodeReadOnlyTrx rtx = this.asXmlNodeReadTrx();
            if (rtx.getNodeKey() >= 0L) {
                return false;
            }
            if (rtx.getTypeKey() == rtx.keyForName("xs:boolean")) {
                return !Boolean.parseBoolean(rtx.getValue());
            }
            return false;
        }
        return false;
    }
}

