/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis.filter.json;

import io.sirix.api.Filter;
import io.sirix.api.ResourceSession;
import io.sirix.api.json.JsonNodeReadOnlyTrx;
import io.sirix.api.json.JsonNodeTrx;
import io.sirix.axis.AbstractTemporalAxis;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class TemporalJsonNodeReadFilterAxis<F extends Filter<JsonNodeReadOnlyTrx>>
extends AbstractTemporalAxis<JsonNodeReadOnlyTrx, JsonNodeTrx> {
    private final AbstractTemporalAxis<JsonNodeReadOnlyTrx, JsonNodeTrx> mAxis;
    private final List<F> mAxisFilter;

    @SafeVarargs
    public TemporalJsonNodeReadFilterAxis(AbstractTemporalAxis<JsonNodeReadOnlyTrx, JsonNodeTrx> axis, F firstAxisTest, F ... axisTest) {
        Objects.requireNonNull(firstAxisTest);
        this.mAxis = axis;
        this.mAxisFilter = new ArrayList<F>();
        this.mAxisFilter.add(firstAxisTest);
        if (axisTest != null) {
            int length = axisTest.length;
            for (int i = 0; i < length; ++i) {
                this.mAxisFilter.add(axisTest[i]);
            }
        }
    }

    protected JsonNodeReadOnlyTrx computeNext() {
        while (this.mAxis.hasNext()) {
            JsonNodeReadOnlyTrx rtx = (JsonNodeReadOnlyTrx)this.mAxis.next();
            boolean filterResult = this.doFilter(rtx);
            if (filterResult) {
                return rtx;
            }
            rtx.close();
        }
        return (JsonNodeReadOnlyTrx)this.endOfData();
    }

    private boolean doFilter(JsonNodeReadOnlyTrx rtx) {
        boolean filterResult = true;
        for (Filter filter : this.mAxisFilter) {
            filter.setTrx(rtx);
            if (filterResult = filterResult && filter.filter()) continue;
            break;
        }
        return filterResult;
    }

    public AbstractTemporalAxis<JsonNodeReadOnlyTrx, JsonNodeTrx> getAxis() {
        return this.mAxis;
    }

    @Override
    public ResourceSession<JsonNodeReadOnlyTrx, JsonNodeTrx> getResourceManager() {
        return this.mAxis.getResourceManager();
    }
}

