/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis.pathsummary;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.sirix.axis.IncludeSelf;
import io.sirix.index.path.summary.PathNode;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public abstract class AbstractAxis
implements Iterator<PathNode>,
Iterable<PathNode> {
    protected PathNode nextNode;
    protected PathNode startPathNode;
    private final IncludeSelf includeSelf;
    private State state = State.NOT_READY;

    public AbstractAxis(PathNode pathNode) {
        this.startPathNode = Objects.requireNonNull(pathNode);
        this.nextNode = pathNode;
        this.includeSelf = IncludeSelf.NO;
        this.reset(this.startPathNode);
    }

    public AbstractAxis(PathNode pathNode, IncludeSelf includeSelf) {
        this.startPathNode = Objects.requireNonNull(pathNode);
        this.includeSelf = Objects.requireNonNull(includeSelf);
        this.reset(this.startPathNode);
    }

    public PathNode getStartPathNode() {
        return this.startPathNode;
    }

    @Override
    public final Iterator<PathNode> iterator() {
        return this;
    }

    protected PathNode done() {
        return null;
    }

    @Override
    public final boolean hasNext() {
        Preconditions.checkState((this.state != State.FAILED ? 1 : 0) != 0);
        switch (this.state.ordinal()) {
            case 2: {
                return false;
            }
            case 0: {
                return true;
            }
        }
        boolean hasNext = this.tryToComputeNext();
        if (hasNext) {
            return true;
        }
        this.reset(this.startPathNode);
        return false;
    }

    private boolean tryToComputeNext() {
        this.state = State.FAILED;
        this.nextNode = this.nextNode();
        if (this.nextNode == null) {
            this.state = State.DONE;
        }
        if (this.state == State.DONE) {
            return false;
        }
        this.state = State.READY;
        return true;
    }

    protected abstract PathNode nextNode();

    @Override
    public final PathNode next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.NOT_READY;
        return this.nextNode;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    public void reset(PathNode pathNode) {
        this.startPathNode = pathNode;
        this.nextNode = pathNode;
        this.state = State.NOT_READY;
    }

    public final PathNode peek() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.nextNode;
    }

    public final IncludeSelf includeSelf() {
        return this.includeSelf;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pathNode", (Object)this.nextNode).toString();
    }

    private static enum State {
        READY,
        NOT_READY,
        DONE,
        FAILED;

    }
}

