/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis.pathsummary;

import com.google.common.base.Preconditions;
import io.sirix.axis.IncludeSelf;
import io.sirix.axis.pathsummary.AbstractAxis;
import io.sirix.index.path.summary.PathNode;
import io.sirix.index.path.summary.PathSummaryReader;
import io.sirix.settings.Fixed;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import org.checkerframework.checker.index.qual.NonNegative;

public final class LevelOrderSettingInMemoryInstancesAxis
extends AbstractAxis {
    private final PathSummaryReader reader;
    private Deque<PathNode> firstChildren;
    private boolean isFirst;
    private int filterLevel = Integer.MAX_VALUE;
    private int level;

    public static Builder newBuilder(PathSummaryReader rtx) {
        return new Builder(rtx);
    }

    private LevelOrderSettingInMemoryInstancesAxis(Builder builder) {
        super(builder.reader.getPathNode(), builder.includeSelf);
        this.filterLevel = builder.filterLevel;
        this.reader = builder.reader;
    }

    @Override
    public void reset(PathNode pathNode) {
        super.reset(pathNode);
        this.level = 0;
        this.isFirst = true;
        this.firstChildren = new ArrayDeque<PathNode>();
        if (this.reader != null) {
            this.reader.moveTo(pathNode.getNodeKey());
        }
    }

    @Override
    protected PathNode nextNode() {
        long nodeKey = this.nextNode.getNodeKey();
        this.reader.moveTo(nodeKey);
        if (this.isFirst) {
            this.isFirst = false;
            if (this.includeSelf() == IncludeSelf.YES) {
                if (this.nextNode.getParent() == null && this.reader.hasParent() && this.reader.getParentKey() != Fixed.DOCUMENT_NODE_KEY.getStandardProperty()) {
                    this.reader.moveToParent();
                    PathNode parentNode = this.reader.getPathNode();
                    this.nextNode.setParent(parentNode);
                    this.reader.moveTo(nodeKey);
                }
                return this.nextNode;
            }
            if (this.nextNode.hasRightSibling()) {
                return this.getRightSibling(nodeKey);
            }
            if (this.nextNode.hasFirstChild()) {
                return this.getFirstChild(nodeKey);
            }
            return this.done();
        }
        if (this.nextNode.hasRightSibling()) {
            if (this.nextNode.hasFirstChild()) {
                this.firstChildren.add(this.getFirstChild(nodeKey));
            }
            return this.getRightSibling(nodeKey);
        }
        if (this.nextNode.hasFirstChild()) {
            this.firstChildren.add(this.getFirstChild(nodeKey));
        }
        if (!this.firstChildren.isEmpty()) {
            ++this.level;
            if (this.level > this.filterLevel) {
                return this.done();
            }
            PathNode pathNode = this.firstChildren.pop();
            this.reader.moveTo(pathNode.getNodeKey());
            return pathNode;
        }
        if (this.nextNode.hasFirstChild()) {
            ++this.level;
            if (this.level > this.filterLevel) {
                return this.done();
            }
            return this.getFirstChild(nodeKey);
        }
        return this.done();
    }

    private PathNode getFirstChild(long nodeKey) {
        PathNode firstChild = this.nextNode.getFirstChild();
        if (firstChild == null) {
            this.reader.moveToFirstChild();
            firstChild = this.reader.getPathNode();
            this.nextNode.setFirstChild(firstChild);
            this.reader.moveTo(nodeKey);
        }
        if (firstChild.getParent() == null) {
            firstChild.setParent(this.nextNode);
        }
        return firstChild;
    }

    private PathNode getRightSibling(long nodeKey) {
        PathNode rightSibling = this.nextNode.getRightSibling();
        if (rightSibling == null) {
            this.reader.moveToRightSibling();
            rightSibling = this.reader.getPathNode();
            this.nextNode.setRightSibling(rightSibling);
            this.reader.moveTo(nodeKey);
        }
        if (rightSibling.getLeftSibling() == null) {
            PathNode parentNode = this.nextNode.getParent();
            rightSibling.setParent(parentNode);
            rightSibling.setLeftSibling(this.nextNode);
        }
        return rightSibling;
    }

    public int getCurrentLevel() {
        return this.level;
    }

    public static class Builder {
        private int filterLevel = Integer.MAX_VALUE;
        private final PathSummaryReader reader;
        private IncludeSelf includeSelf = IncludeSelf.NO;

        public Builder(PathSummaryReader pathSummaryReader) {
            this.reader = Objects.requireNonNull(pathSummaryReader);
        }

        public Builder includeSelf() {
            this.includeSelf = IncludeSelf.YES;
            return this;
        }

        public Builder filterLevel(@NonNegative int filterLevel) {
            Preconditions.checkArgument((filterLevel >= 0 ? 1 : 0) != 0, (Object)"filterLevel must be >= 0!");
            this.filterLevel = filterLevel;
            return this;
        }

        public LevelOrderSettingInMemoryInstancesAxis build() {
            return new LevelOrderSettingInMemoryInstancesAxis(this);
        }
    }
}

