/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis.pathsummary.filter;

import io.sirix.axis.pathsummary.AbstractAxis;
import io.sirix.index.path.summary.PathNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

public final class FilterAxis
extends AbstractAxis {
    private final AbstractAxis axis;
    private final List<Predicate<PathNode>> axisFilter;

    @SafeVarargs
    public FilterAxis(AbstractAxis axis, Predicate<PathNode> firstAxisTest, Predicate<PathNode> ... axisTests) {
        super(axis.getStartPathNode());
        this.axis = axis;
        this.axisFilter = new ArrayList<Predicate<PathNode>>();
        this.axisFilter.add(firstAxisTest);
        if (axisTests != null) {
            Collections.addAll(this.axisFilter, axisTests);
        }
    }

    @Override
    protected PathNode nextNode() {
        while (this.axis.hasNext()) {
            PathNode node = this.axis.next();
            boolean filterResult = true;
            for (Predicate<PathNode> filter : this.axisFilter) {
                if (filterResult = filterResult && filter.test(node)) continue;
                break;
            }
            if (!filterResult) continue;
            return node;
        }
        return this.done();
    }
}

