/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis.temporal;

import io.sirix.api.NodeCursor;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.api.NodeTrx;
import io.sirix.api.ResourceSession;
import io.sirix.axis.AbstractTemporalAxis;
import java.util.Objects;

public final class AllTimeAxis<R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor>
extends AbstractTemporalAxis<R, W> {
    private int revision;
    private final ResourceSession<R, W> resourceSession;
    private final long nodeKey;
    private boolean hasMoved;

    public AllTimeAxis(ResourceSession<R, W> resourceSession, R rtx) {
        this.resourceSession = Objects.requireNonNull(resourceSession);
        this.revision = 1;
        this.nodeKey = rtx.getNodeKey();
    }

    protected R computeNext() {
        while (this.revision <= this.resourceSession.getMostRecentRevisionNumber()) {
            R rtx = this.resourceSession.beginNodeReadOnlyTrx(this.revision);
            ++this.revision;
            if (rtx.moveTo(this.nodeKey)) {
                this.hasMoved = true;
                return rtx;
            }
            if (!this.hasMoved) continue;
            rtx.close();
            return (R)((NodeReadOnlyTrx)this.endOfData());
        }
        return (R)((NodeReadOnlyTrx)this.endOfData());
    }

    @Override
    public ResourceSession<R, W> getResourceManager() {
        return this.resourceSession;
    }
}

