/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis.temporal;

import io.sirix.api.NodeCursor;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.api.NodeTrx;
import io.sirix.api.ResourceSession;
import io.sirix.axis.AbstractTemporalAxis;
import java.util.Objects;

public final class FirstAxis<R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor>
extends AbstractTemporalAxis<R, W> {
    private final ResourceSession<R, W> resourceSession;
    private final long nodeKey;
    private boolean first;

    public FirstAxis(ResourceSession<R, W> resourceSession, R rtx) {
        this.resourceSession = Objects.requireNonNull(resourceSession);
        this.nodeKey = rtx.getNodeKey();
        this.first = true;
    }

    protected R computeNext() {
        if (this.first) {
            this.first = false;
            R rtx = this.resourceSession.beginNodeReadOnlyTrx(1);
            if (rtx.moveTo(this.nodeKey)) {
                return rtx;
            }
            rtx.close();
            return (R)((NodeReadOnlyTrx)this.endOfData());
        }
        return (R)((NodeReadOnlyTrx)this.endOfData());
    }

    @Override
    public ResourceSession<R, W> getResourceManager() {
        return this.resourceSession;
    }
}

