/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis.visitor;

import com.google.common.base.Preconditions;
import io.sirix.access.trx.node.xml.AbstractXmlNodeVisitor;
import io.sirix.api.visitor.VisitResult;
import io.sirix.api.visitor.VisitResultType;
import io.sirix.api.xml.XmlNodeTrx;
import io.sirix.axis.visitor.LocalVisitResult;
import io.sirix.diff.algorithm.fmse.Matching;
import io.sirix.exception.SirixException;
import io.sirix.node.NodeKind;
import io.sirix.node.immutable.xml.ImmutableComment;
import io.sirix.node.immutable.xml.ImmutableElement;
import io.sirix.node.immutable.xml.ImmutablePI;
import io.sirix.node.immutable.xml.ImmutableText;
import io.sirix.node.interfaces.immutable.ImmutableNode;
import io.sirix.utils.LogWrapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import org.checkerframework.checker.index.qual.NonNegative;
import org.slf4j.LoggerFactory;

public class DeleteFMSEVisitor
extends AbstractXmlNodeVisitor {
    private static final LogWrapper LOGWRAPPER = new LogWrapper(LoggerFactory.getLogger(DeleteFMSEVisitor.class));
    private final Matching matching;
    private final XmlNodeTrx wtx;
    private final long startKey;

    public DeleteFMSEVisitor(XmlNodeTrx wtx, Matching matching, @NonNegative long startKey) {
        this.wtx = Objects.requireNonNull(wtx);
        this.matching = Objects.requireNonNull(matching);
        Preconditions.checkArgument((startKey >= 0L ? 1 : 0) != 0, (Object)"start key must be >= 0!");
        this.startKey = startKey;
    }

    @Override
    public VisitResult visit(ImmutableElement node) {
        int i;
        Long partner = this.matching.partner(node.getNodeKey());
        if (partner == null) {
            VisitResult retVal = this.delete(node);
            if (node.getNodeKey() == this.startKey) {
                retVal = VisitResultType.TERMINATE;
            }
            return retVal;
        }
        this.wtx.moveTo(node.getNodeKey());
        long nodeKey = node.getNodeKey();
        ArrayList<Long> keysToDelete = new ArrayList<Long>(this.wtx.getAttributeCount() + this.wtx.getNamespaceCount());
        int attCount = this.wtx.getAttributeCount();
        for (i = 0; i < attCount; ++i) {
            this.wtx.moveToAttribute(i);
            long attNodeKey = this.wtx.getNodeKey();
            if (this.matching.partner(attNodeKey) == null) {
                keysToDelete.add(attNodeKey);
            }
            this.wtx.moveTo(nodeKey);
        }
        int nspCount = this.wtx.getNamespaceCount();
        for (i = 0; i < nspCount; ++i) {
            this.wtx.moveToNamespace(i);
            long namespNodeKey = this.wtx.getNodeKey();
            if (this.matching.partner(namespNodeKey) == null) {
                keysToDelete.add(namespNodeKey);
            }
            this.wtx.moveTo(nodeKey);
        }
        Iterator iterator = keysToDelete.iterator();
        while (iterator.hasNext()) {
            long keyToDelete = (Long)iterator.next();
            this.wtx.moveTo(keyToDelete);
            try {
                this.wtx.remove();
            }
            catch (SirixException e) {
                LOGWRAPPER.error(e.getMessage(), e);
            }
        }
        this.wtx.moveTo(nodeKey);
        return VisitResultType.CONTINUE;
    }

    @Override
    public VisitResult visit(ImmutableText node) {
        return this.deleteLeaf(node);
    }

    @Override
    public VisitResult visit(ImmutableComment node) {
        return this.deleteLeaf(node);
    }

    @Override
    public VisitResult visit(ImmutablePI node) {
        return this.deleteLeaf(node);
    }

    private VisitResult deleteLeaf(ImmutableNode node) {
        Long partner = this.matching.partner(node.getNodeKey());
        if (partner == null) {
            VisitResult retVal = this.delete(node);
            if (node.getNodeKey() == this.startKey) {
                retVal = VisitResultType.TERMINATE;
            }
            return retVal;
        }
        return VisitResultType.CONTINUE;
    }

    private VisitResult delete(ImmutableNode node) {
        try {
            this.wtx.moveTo(node.getNodeKey());
            long nodeKey = this.wtx.getNodeKey();
            boolean removeTextNode = false;
            boolean resetValue = false;
            if (this.wtx.hasLeftSibling() && this.wtx.moveToLeftSibling() && this.wtx.getKind() == NodeKind.TEXT && this.wtx.moveToRightSibling() && this.wtx.hasRightSibling() && this.wtx.moveToRightSibling() && this.wtx.getKind() == NodeKind.TEXT) {
                Long partner = this.matching.partner(this.wtx.getNodeKey());
                if (partner == null) {
                    resetValue = true;
                }
                removeTextNode = true;
            }
            this.wtx.moveTo(nodeKey);
            if (!removeTextNode) {
                boolean movedToParent = this.wtx.moveToParent();
                assert (movedToParent);
                long parentNodeKey = this.wtx.getNodeKey();
                if (this.wtx.getChildCount() == 1L && this.wtx.hasRightSibling()) {
                    this.wtx.moveTo(nodeKey);
                    this.wtx.remove();
                    assert (this.wtx.getNodeKey() == parentNodeKey);
                    return LocalVisitResult.SKIPSUBTREEPOPSTACK;
                }
            }
            this.wtx.moveTo(nodeKey);
            if (!this.wtx.hasRightSibling() && this.wtx.hasLeftSibling()) {
                long leftSiblKey = this.wtx.getLeftSiblingKey();
                this.wtx.remove();
                assert (this.wtx.getNodeKey() == leftSiblKey);
                return VisitResultType.SKIPSUBTREE;
            }
            if (this.wtx.hasRightSibling() && this.wtx.hasLeftSibling()) {
                String value;
                long rightSiblKey = this.wtx.getRightSiblingKey();
                this.wtx.moveToRightSibling();
                long rightRightSiblKey = this.wtx.getRightSiblingKey();
                this.wtx.moveTo(nodeKey);
                if (removeTextNode) {
                    this.wtx.moveToLeftSibling();
                    value = this.wtx.getValue();
                } else {
                    value = "";
                }
                this.wtx.moveTo(nodeKey);
                this.wtx.remove();
                if (removeTextNode) {
                    if (resetValue && !value.equals(this.wtx.getValue())) {
                        this.wtx.setValue(value);
                    }
                    assert (this.wtx.getKind() == NodeKind.TEXT);
                    assert (this.wtx.getRightSiblingKey() == rightRightSiblKey);
                    return VisitResultType.CONTINUE;
                }
                boolean moved = this.wtx.moveToLeftSibling();
                assert (moved);
                assert (this.wtx.getRightSiblingKey() == rightSiblKey);
                return VisitResultType.SKIPSUBTREE;
            }
            if (this.wtx.hasRightSibling() && !this.wtx.hasLeftSibling()) {
                long rightSiblKey = this.wtx.getRightSiblingKey();
                this.wtx.remove();
                this.wtx.moveToParent();
                assert (this.wtx.getFirstChildKey() == rightSiblKey);
                return VisitResultType.CONTINUE;
            }
            long parentKey = this.wtx.getParentKey();
            this.wtx.remove();
            assert (this.wtx.getNodeKey() == parentKey);
        }
        catch (SirixException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
        return VisitResultType.CONTINUE;
    }
}

