/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis.visitor;

import com.google.common.base.Preconditions;
import io.brackit.query.atomic.QNm;
import io.sirix.access.trx.node.xml.AbstractXmlNodeVisitor;
import io.sirix.api.visitor.VisitResult;
import io.sirix.api.visitor.VisitResultType;
import io.sirix.api.xml.XmlNodeTrx;
import io.sirix.axis.visitor.LocalVisitResult;
import io.sirix.exception.SirixException;
import io.sirix.node.NodeKind;
import io.sirix.node.immutable.xml.ImmutableElement;
import io.sirix.node.immutable.xml.ImmutableText;
import io.sirix.node.interfaces.immutable.ImmutableNode;
import io.sirix.service.xml.shredder.XmlShredder;
import io.sirix.utils.LogWrapper;
import java.util.Objects;
import java.util.Random;
import org.slf4j.LoggerFactory;

public final class ModificationVisitor
extends AbstractXmlNodeVisitor {
    private static final LogWrapper LOGWRAPPER = new LogWrapper(LoggerFactory.getLogger(ModificationVisitor.class));
    private static final int MODIFY_EVERY = 1111;
    private final XmlNodeTrx wtx;
    private final Random random = new Random();
    private final long startKey;
    private long nodeIndex;

    public ModificationVisitor(XmlNodeTrx wtx, long startKey) {
        this.wtx = Objects.requireNonNull(wtx);
        Preconditions.checkArgument((startKey >= 0L ? 1 : 0) != 0, (Object)"start key must be >= 0!");
        this.startKey = startKey;
        this.nodeIndex = 1L;
    }

    @Override
    public VisitResult visit(ImmutableElement node) {
        return this.processNode(node);
    }

    private VisitResult processNode(ImmutableNode node) {
        assert (node != null);
        VisitResult result = this.modify(node);
        if (node.getNodeKey() == this.startKey) {
            return VisitResultType.TERMINATE;
        }
        return result;
    }

    @Override
    public VisitResult visit(ImmutableText node) {
        return this.processNode(node);
    }

    private VisitResult modify(ImmutableNode node) {
        assert (node != null);
        if (this.nodeIndex % 1111L == 0L) {
            this.nodeIndex = 1L;
            try {
                switch (this.random.nextInt(4)) {
                    case 0: {
                        QNm insert = new QNm("testInsert");
                        long key = this.wtx.getNodeKey();
                        this.wtx.insertElementAsLeftSibling(insert);
                        boolean moved = this.wtx.moveTo(key);
                        assert (moved);
                        return VisitResultType.CONTINUE;
                    }
                    case 1: {
                        if (this.wtx.getKind() == NodeKind.TEXT) {
                            this.wtx.setValue("testUpdate");
                        } else if (this.wtx.getKind() == NodeKind.ELEMENT) {
                            this.wtx.setName(new QNm("testUpdate"));
                        }
                        return VisitResultType.CONTINUE;
                    }
                    case 2: {
                        return this.delete();
                    }
                    case 3: {
                        this.wtx.replaceNode(XmlShredder.createStringReader("<foo/>"));
                        return VisitResultType.CONTINUE;
                    }
                }
            }
            catch (SirixException e) {
                LOGWRAPPER.error(e.getMessage(), e);
                return VisitResultType.TERMINATE;
            }
        } else {
            ++this.nodeIndex;
            return VisitResultType.CONTINUE;
        }
        return VisitResultType.CONTINUE;
    }

    private VisitResult delete() throws SirixException {
        try {
            long nodeKey = this.wtx.getNodeKey();
            boolean removeTextNode = this.wtx.getLeftSiblingKind() == NodeKind.TEXT && this.wtx.getRightSiblingKind() == NodeKind.TEXT;
            this.wtx.moveTo(nodeKey);
            if (!removeTextNode) {
                boolean movedToParent = this.wtx.moveToParent();
                assert (movedToParent);
                long parentNodeKey = this.wtx.getNodeKey();
                if (this.wtx.getChildCount() == 1L && this.wtx.hasRightSibling()) {
                    this.wtx.moveTo(nodeKey);
                    this.wtx.remove();
                    assert (this.wtx.getNodeKey() == parentNodeKey);
                    return LocalVisitResult.SKIPSUBTREEPOPSTACK;
                }
            }
            this.wtx.moveTo(nodeKey);
            if (!this.wtx.hasRightSibling() && this.wtx.hasLeftSibling()) {
                long leftSiblKey = this.wtx.getLeftSiblingKey();
                this.wtx.remove();
                assert (this.wtx.getNodeKey() == leftSiblKey);
                return VisitResultType.SKIPSUBTREE;
            }
            if (this.wtx.hasRightSibling() && this.wtx.hasLeftSibling()) {
                long rightSiblKey = this.wtx.getRightSiblingKey();
                this.wtx.moveToRightSibling();
                long rightRightSiblKey = this.wtx.getRightSiblingKey();
                this.wtx.moveTo(nodeKey);
                this.wtx.remove();
                if (removeTextNode) {
                    assert (this.wtx.getKind() == NodeKind.TEXT);
                    assert (this.wtx.getRightSiblingKey() == rightRightSiblKey);
                    return VisitResultType.CONTINUE;
                }
                boolean moved = this.wtx.moveToLeftSibling();
                assert (moved);
                assert (this.wtx.getRightSiblingKey() == rightSiblKey);
                return VisitResultType.SKIPSUBTREE;
            }
            if (this.wtx.hasRightSibling() && !this.wtx.hasLeftSibling()) {
                long rightSiblKey = this.wtx.getRightSiblingKey();
                this.wtx.remove();
                this.wtx.moveToParent();
                assert (this.wtx.getFirstChildKey() == rightSiblKey);
                return VisitResultType.CONTINUE;
            }
            long parentKey = this.wtx.getParentKey();
            this.wtx.remove();
            assert (this.wtx.getNodeKey() == parentKey);
        }
        catch (SirixException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
        return VisitResultType.CONTINUE;
    }
}

