/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.cache;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.sirix.cache.Cache;
import io.sirix.cache.EmptyCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class LRUCache<K, V>
implements Cache<K, V> {
    static final int CACHE_CAPACITY = 1;
    private final Map<K, V> map;
    private final Cache<K, V> secondCache;

    public LRUCache(Cache<K, V> secondCache) {
        assert (secondCache != null);
        this.secondCache = secondCache;
        this.map = new LinkedHashMap<K, V>(1){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(@Nullable Map.Entry<K, V> eldest) {
                boolean returnVal = false;
                if (this.size() > 1) {
                    if (eldest != null) {
                        Object key = eldest.getKey();
                        Object value = eldest.getValue();
                        if (key != null && value != null) {
                            LRUCache.this.secondCache.put(key, value);
                        }
                    }
                    returnVal = true;
                }
                return returnVal;
            }
        };
    }

    public LRUCache() {
        this(new EmptyCache());
    }

    @Override
    public V get(K key) {
        V value = this.map.get(key);
        if (value == null && (value = this.secondCache.get(key)) != null) {
            this.map.put(key, value);
        }
        return value;
    }

    @Override
    public void put(K key, V value) {
        this.map.put(key, value);
    }

    @Override
    public void clear() {
        this.map.clear();
        this.secondCache.clear();
    }

    public int usedEntries() {
        return this.map.size();
    }

    public Collection<Map.Entry<? super K, ? super V>> getAll() {
        return new ArrayList<Map.Entry<? super K, ? super V>>(this.map.entrySet());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("First Cache", this.map).add("Second Cache", this.secondCache).toString();
    }

    @Override
    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (K key : keys) {
            if (this.map.get(key) == null) continue;
            builder.put(key, this.map.get(key));
        }
        return builder.build();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.map.putAll(Objects.requireNonNull(map));
    }

    @Override
    public void toSecondCache() {
        this.secondCache.putAll(this.map);
    }

    public Map<K, V> getMap() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public void remove(K key) {
        this.map.remove(key);
        if (this.secondCache.get(key) != null) {
            this.secondCache.remove(key);
        }
    }

    @Override
    public void close() {
        this.map.clear();
        this.secondCache.close();
    }
}

