/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalListener;
import io.sirix.cache.Cache;
import io.sirix.page.IndirectPage;
import io.sirix.page.PageReference;
import io.sirix.page.interfaces.Page;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class PageCache
implements Cache<PageReference, Page> {
    private final com.github.benmanes.caffeine.cache.Cache<PageReference, Page> pageCache;

    public PageCache(int maxSize) {
        RemovalListener removalListener = (key, value, cause) -> key.setPage(null);
        this.pageCache = Caffeine.newBuilder().maximumSize((long)maxSize).expireAfterAccess(5L, TimeUnit.MINUTES).scheduler(scheduler).removalListener(removalListener).build();
    }

    @Override
    public void clear() {
        this.pageCache.invalidateAll();
    }

    @Override
    public Page get(PageReference key) {
        Page page = (Page)this.pageCache.getIfPresent((Object)key);
        if (page instanceof IndirectPage) {
            IndirectPage indirectPage = (IndirectPage)page;
            page = new IndirectPage(indirectPage);
        }
        return page;
    }

    @Override
    public void put(PageReference key, Page value) {
        this.pageCache.put((Object)key, (Object)value);
    }

    @Override
    public void putAll(Map<? extends PageReference, ? extends Page> map) {
        this.pageCache.putAll(map);
    }

    @Override
    public void toSecondCache() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<PageReference, Page> getAll(Iterable<? extends PageReference> keys) {
        return this.pageCache.getAllPresent(keys);
    }

    @Override
    public void remove(PageReference key) {
        this.pageCache.invalidate((Object)key);
    }

    @Override
    public void close() {
    }
}

