/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.cache;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.sirix.page.KeyValueLeafPage;
import io.sirix.page.interfaces.Page;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PageContainer {
    private final Page complete;
    private final Page modified;
    private static final PageContainer EMPTY_INSTANCE = new PageContainer(null, null);

    public static PageContainer emptyInstance() {
        return EMPTY_INSTANCE;
    }

    public static PageContainer getInstance(Page complete, Page modifying) {
        assert (complete != null);
        assert (modifying != null);
        return new PageContainer(complete, modifying);
    }

    private PageContainer(Page complete, Page modified) {
        this.complete = complete;
        this.modified = modified;
    }

    public Page getComplete() {
        return this.complete;
    }

    public Page getModified() {
        return this.modified;
    }

    public KeyValueLeafPage getCompleteAsUnorderedKeyValuePage() {
        return (KeyValueLeafPage)this.complete;
    }

    public KeyValueLeafPage getModifiedAsUnorderedKeyValuePage() {
        return (KeyValueLeafPage)this.modified;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.complete, this.modified});
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof PageContainer)) {
            return false;
        }
        PageContainer other = (PageContainer)obj;
        return Objects.equal((Object)this.complete, (Object)other.complete) && Objects.equal((Object)this.modified, (Object)other.modified);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("complete page", (Object)this.complete).add("modified page", (Object)this.modified).toString();
    }
}

