/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.cache;

import io.sirix.cache.PageContainer;
import io.sirix.page.PageReference;
import java.util.ArrayList;
import java.util.List;

public final class TransactionIntentLog
implements AutoCloseable {
    private final List<PageContainer> list;
    private int logKey = 0;

    public TransactionIntentLog(int maxInMemoryCapacity) {
        this.list = new ArrayList<PageContainer>(maxInMemoryCapacity);
    }

    public PageContainer get(PageReference key) {
        int logKey = key.getLogKey();
        if (logKey >= this.logKey || logKey < 0) {
            return null;
        }
        return this.list.get(logKey);
    }

    public void put(PageReference key, PageContainer value) {
        key.setKey(-15L);
        key.setPage(null);
        key.setLogKey(this.logKey);
        this.list.add(value);
        ++this.logKey;
    }

    public void clear() {
        this.logKey = 0;
        this.list.clear();
    }

    public List<PageContainer> getList() {
        return this.list;
    }

    @Override
    public void close() {
        this.logKey = 0;
        this.list.clear();
    }
}

