/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.diff;

import io.sirix.access.trx.node.HashType;
import io.sirix.api.NodeCursor;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.api.NodeTrx;
import io.sirix.axis.DescendantAxis;
import io.sirix.axis.IncludeSelf;
import io.sirix.diff.AbstractDiffObservable;
import io.sirix.diff.DepthCounter;
import io.sirix.diff.DiffDepth;
import io.sirix.diff.DiffFactory;
import io.sirix.diff.DiffObserver;
import io.sirix.diff.FoundMatchingNode;
import io.sirix.exception.SirixException;
import io.sirix.node.NodeKind;
import java.util.Objects;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

@NonNull
abstract class AbstractDiff<R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor>
extends AbstractDiffObservable {
    private final long oldMaxDepth;
    private final HashType hashKind;
    private DiffFactory.DiffType diff;
    private DiffFactory.DiffOptimized diffKind;
    private final DepthCounter depth;
    private long rootKey;
    private final long oldRootKey;
    private final boolean newRtxMoved;
    private final boolean oldRtxMoved;
    private final boolean isGUI;
    private boolean isFirst;
    private final R newRtx;
    private final R oldRtx;
    private final boolean skipSubtrees;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractDiff(DiffFactory.Builder<R, W> builder) throws SirixException {
        this.skipSubtrees = builder.skipSubtrees;
        this.diffKind = Objects.requireNonNull(builder).kind;
        this.oldMaxDepth = builder.oldMaxDepth;
        Object object = builder.resMgr;
        synchronized (object) {
            this.newRtx = builder.resMgr.beginNodeReadOnlyTrx(builder.newRev);
            this.oldRtx = builder.resMgr.beginNodeReadOnlyTrx(builder.oldRev);
            this.hashKind = builder.hashKind;
        }
        this.newRtxMoved = this.newRtx.moveTo(builder.newStartKey);
        this.oldRtxMoved = this.oldRtx.moveTo(builder.oldStartKey);
        if (((NodeCursor)this.newRtx).getKind() == this.documentNode()) {
            ((NodeCursor)this.newRtx).moveToFirstChild();
        }
        if (((NodeCursor)this.oldRtx).getKind() == this.documentNode()) {
            ((NodeCursor)this.oldRtx).moveToFirstChild();
        }
        this.rootKey = builder.newStartKey;
        this.oldRootKey = builder.oldStartKey;
        object = builder.observers;
        synchronized (object) {
            for (DiffObserver observer : builder.observers) {
                this.addObserver(observer);
            }
        }
        this.diff = DiffFactory.DiffType.SAME;
        this.diffKind = builder.kind;
        this.depth = new DepthCounter(builder.newDepth, builder.oldDepth);
        this.isGUI = builder.isGUI;
        this.isFirst = true;
    }

    void diffMovement() {
        assert (this.hashKind != null);
        assert (this.newRtx != null);
        assert (this.oldRtx != null);
        assert (this.diff != null);
        assert (this.diffKind != null);
        if (!this.newRtxMoved) {
            this.fireDeletes();
            if (!this.isGUI || this.depth.getNewDepth() == 0) {
                this.fireInserts();
            }
            this.done();
            return;
        }
        if (!this.oldRtxMoved) {
            this.fireInserts();
            if (!this.isGUI || this.depth.getOldDepth() == 0) {
                this.fireDeletes();
            }
            this.done();
            return;
        }
        this.diff = this.hashKind == HashType.NONE || this.diffKind == DiffFactory.DiffOptimized.NO ? this.diff(this.newRtx, this.oldRtx, this.depth) : this.optimizedDiff(this.newRtx, this.oldRtx, this.depth);
        this.isFirst = false;
        if (this.diff != DiffFactory.DiffType.SAMEHASH) {
            while (((NodeCursor)this.oldRtx).getKind() != this.documentNode() && this.diff == DiffFactory.DiffType.DELETED || this.moveCursor(this.newRtx, Revision.NEW, Move.FOLLOWING)) {
                if (this.diff != DiffFactory.DiffType.INSERTED) {
                    this.moveCursor(this.oldRtx, Revision.OLD, Move.FOLLOWING);
                }
                if (((NodeCursor)this.newRtx).getKind() == this.documentNode() && ((NodeCursor)this.oldRtx).getKind() == this.documentNode()) continue;
                if (this.hashKind == HashType.NONE || this.diffKind == DiffFactory.DiffOptimized.NO) {
                    this.diff = this.diff(this.newRtx, this.oldRtx, this.depth);
                    continue;
                }
                this.diff = this.optimizedDiff(this.newRtx, this.oldRtx, this.depth);
            }
            if (((NodeCursor)this.oldRtx).getKind() != this.documentNode()) {
                this.rootKey = this.oldRootKey;
                if (this.diff == DiffFactory.DiffType.INSERTED) {
                    this.emitDeleteDiff();
                }
                boolean moved = true;
                if (this.diffKind == DiffFactory.DiffOptimized.HASHED && this.diff == DiffFactory.DiffType.SAMEHASH && (moved = this.moveToFollowingNode(this.oldRtx, Revision.OLD))) {
                    this.emitDeleteDiff();
                }
                if (moved) {
                    if (this.skipSubtrees) {
                        while (this.moveToFollowingNode(this.oldRtx, Revision.OLD)) {
                            this.emitDeleteDiff();
                        }
                    } else {
                        while (this.moveCursor(this.oldRtx, Revision.OLD, Move.DOCUMENT_ORDER)) {
                            this.emitDeleteDiff();
                        }
                    }
                }
            }
        }
        this.diffDone();
    }

    private void emitDeleteDiff() {
        this.diff = DiffFactory.DiffType.DELETED;
        DiffDepth diffDepth = new DiffDepth(this.depth.getNewDepth(), this.depth.getOldDepth());
        this.fireDiff(this.diff, this.newRtx.getNodeKey(), this.oldRtx.getNodeKey(), diffDepth);
        this.emitNonStructuralDiff(this.newRtx, this.oldRtx, diffDepth, this.diff);
    }

    private void diffDone() throws SirixException {
        this.newRtx.close();
        this.oldRtx.close();
        this.done();
    }

    private void fireDeletes() {
        this.fireDiff(DiffFactory.DiffType.DELETED, this.newRtx.getNodeKey(), this.oldRtx.getNodeKey(), new DiffDepth(this.depth.getNewDepth(), this.depth.getOldDepth()));
        this.isFirst = false;
        if (this.skipSubtrees) {
            this.moveToFollowingNode(this.oldRtx, Revision.OLD);
        } else {
            while (this.moveCursor(this.oldRtx, Revision.OLD, Move.DOCUMENT_ORDER)) {
                DiffDepth depth = new DiffDepth(this.depth.getNewDepth(), this.depth.getOldDepth());
                this.fireDiff(DiffFactory.DiffType.DELETED, this.newRtx.getNodeKey(), this.oldRtx.getNodeKey(), depth);
                this.emitNonStructuralDiff(this.newRtx, this.oldRtx, depth, DiffFactory.DiffType.DELETED);
            }
        }
    }

    private void fireInserts() {
        this.fireDiff(DiffFactory.DiffType.INSERTED, this.newRtx.getNodeKey(), this.oldRtx.getNodeKey(), new DiffDepth(this.depth.getNewDepth(), this.depth.getOldDepth()));
        this.isFirst = false;
        if (this.skipSubtrees) {
            this.moveToFollowingNode(this.newRtx, Revision.NEW);
        } else {
            while (this.moveCursor(this.newRtx, Revision.NEW, Move.DOCUMENT_ORDER)) {
                DiffDepth depth = new DiffDepth(this.depth.getNewDepth(), this.depth.getOldDepth());
                this.fireDiff(DiffFactory.DiffType.INSERTED, this.newRtx.getNodeKey(), this.oldRtx.getNodeKey(), depth);
                this.emitNonStructuralDiff(this.newRtx, this.oldRtx, depth, DiffFactory.DiffType.DELETED);
            }
        }
    }

    private boolean moveCursor(R rtx, Revision revision, Move move) {
        assert (rtx != null);
        assert (revision != null);
        boolean moved = false;
        if (((NodeCursor)rtx).getKind() != this.documentNode()) {
            switch (this.diff) {
                case SAME: 
                case SAMEHASH: 
                case UPDATED: {
                    moved = this.moveToNext(rtx, revision);
                    break;
                }
                case REPLACED: {
                    moved = this.moveToFollowingNode(rtx, revision);
                    break;
                }
                case INSERTED: 
                case DELETED: {
                    if (move == Move.FOLLOWING) {
                        moved = ((NodeCursor)rtx).getKind() != this.documentNode();
                        break;
                    }
                    moved = this.moveToNext(rtx, revision);
                    break;
                }
            }
        }
        return moved;
    }

    private boolean moveToNext(R rtx, Revision revision) {
        boolean moved = false;
        if (((NodeCursor)rtx).hasFirstChild()) {
            if (((NodeCursor)rtx).getKind() != this.documentNode() && (this.diffKind == DiffFactory.DiffOptimized.HASHED && this.diff == DiffFactory.DiffType.SAMEHASH || this.oldMaxDepth > 0L && ((NodeCursor)rtx).getKind() != NodeKind.OBJECT_KEY && (long)(this.depth.getOldDepth() + 1) >= this.oldMaxDepth)) {
                moved = ((NodeCursor)rtx).moveToRightSibling();
                if (!moved) {
                    moved = this.moveToFollowingNode(rtx, revision);
                }
            } else {
                NodeKind nodeKind = ((NodeCursor)rtx).getKind();
                moved = ((NodeCursor)rtx).moveToFirstChild();
                if (moved && nodeKind != NodeKind.OBJECT_KEY) {
                    switch (revision.ordinal()) {
                        case 1: {
                            this.depth.incrementNewDepth();
                            break;
                        }
                        case 0: {
                            this.depth.incrementOldDepth();
                            break;
                        }
                    }
                }
            }
        } else if (((NodeCursor)rtx).hasRightSibling()) {
            if (rtx.getNodeKey() == this.rootKey) {
                ((NodeCursor)rtx).moveToDocumentRoot();
            } else {
                moved = ((NodeCursor)rtx).moveToRightSibling();
            }
        } else {
            moved = this.moveToFollowingNode(rtx, revision);
        }
        return moved;
    }

    private boolean moveToFollowingNode(R rtx, Revision revision) {
        boolean moved;
        block4: while (!((NodeCursor)rtx).hasRightSibling() && ((NodeCursor)rtx).hasParent() && rtx.getNodeKey() != this.rootKey) {
            moved = ((NodeCursor)rtx).moveToParent();
            if (!moved || ((NodeCursor)rtx).getKind() == NodeKind.OBJECT_KEY) continue;
            switch (revision.ordinal()) {
                case 1: {
                    this.depth.decrementNewDepth();
                    continue block4;
                }
                case 0: {
                    this.depth.decrementOldDepth();
                    continue block4;
                }
            }
        }
        if (rtx.getNodeKey() == this.rootKey) {
            ((NodeCursor)rtx).moveToDocumentRoot();
        }
        moved = ((NodeCursor)rtx).moveToRightSibling();
        return moved;
    }

    DiffFactory.DiffType diff(R newRtx, R oldRtx, DepthCounter depth) {
        assert (newRtx != null);
        assert (oldRtx != null);
        assert (depth != null);
        DiffFactory.DiffType diff = DiffFactory.DiffType.SAME;
        if (this.checkNodes(newRtx, oldRtx)) {
            DiffDepth diffDepth = new DiffDepth(depth.getNewDepth(), depth.getOldDepth());
            this.fireDiff(diff, newRtx.getNodeKey(), oldRtx.getNodeKey(), diffDepth);
            this.emitNonStructuralDiff(newRtx, oldRtx, diffDepth, diff);
        } else {
            diff = this.diffAlgorithm(newRtx, oldRtx, depth);
        }
        return diff;
    }

    DiffFactory.DiffType optimizedDiff(R newRtx, R oldRtx, DepthCounter depth) {
        assert (newRtx != null);
        assert (oldRtx != null);
        assert (depth != null);
        DiffFactory.DiffType diff = DiffFactory.DiffType.SAMEHASH;
        if (newRtx.getNodeKey() != oldRtx.getNodeKey() || newRtx.getHash() != oldRtx.getHash()) {
            if (this.checkNodes(newRtx, oldRtx)) {
                diff = DiffFactory.DiffType.SAME;
                DiffDepth diffDepth = new DiffDepth(depth.getNewDepth(), depth.getOldDepth());
                this.fireDiff(diff, newRtx.getNodeKey(), oldRtx.getNodeKey(), diffDepth);
                this.emitNonStructuralDiff(newRtx, oldRtx, diffDepth, diff);
            } else {
                diff = this.diffAlgorithm(newRtx, oldRtx, depth);
            }
        } else {
            DiffDepth diffDepth = new DiffDepth(depth.getNewDepth(), depth.getOldDepth());
            this.fireDiff(diff, newRtx.getNodeKey(), oldRtx.getNodeKey(), diffDepth);
            this.emitNonStructuralDiff(newRtx, oldRtx, diffDepth, diff);
        }
        return diff;
    }

    private DiffFactory.DiffType diffAlgorithm(R newRtx, R oldRtx, DepthCounter depth) {
        DiffFactory.DiffType diff;
        assert (newRtx != null);
        assert (oldRtx != null);
        assert (depth != null);
        if (depth.getOldDepth() > depth.getNewDepth()) {
            diff = DiffFactory.DiffType.DELETED;
            this.emitDiffs(diff);
        } else if (this.checkUpdate(newRtx, oldRtx)) {
            diff = DiffFactory.DiffType.UPDATED;
            DiffDepth diffDepth = new DiffDepth(depth.getNewDepth(), depth.getOldDepth());
            if (this.checkNodeNamesOrValues(newRtx, oldRtx)) {
                this.fireDiff(DiffFactory.DiffType.SAME, newRtx.getNodeKey(), oldRtx.getNodeKey(), diffDepth);
            } else {
                this.fireDiff(diff, newRtx.getNodeKey(), oldRtx.getNodeKey(), diffDepth);
            }
            this.emitNonStructuralDiff(newRtx, oldRtx, diffDepth, diff);
        } else if (this.checkReplace(newRtx, oldRtx)) {
            diff = DiffFactory.DiffType.REPLACED;
        } else {
            long oldKey = oldRtx.getNodeKey();
            boolean movedOld = oldRtx.moveTo(newRtx.getNodeKey());
            oldRtx.moveTo(oldKey);
            long newKey = newRtx.getNodeKey();
            boolean movedNew = newRtx.moveTo(oldRtx.getNodeKey());
            newRtx.moveTo(newKey);
            if (!movedOld) {
                diff = DiffFactory.DiffType.INSERTED;
            } else if (!movedNew) {
                diff = DiffFactory.DiffType.DELETED;
            } else {
                FoundMatchingNode found = FoundMatchingNode.FALSE;
                while (((NodeCursor)oldRtx).hasRightSibling() && ((NodeCursor)oldRtx).moveToRightSibling() && found == FoundMatchingNode.FALSE) {
                    if (!this.checkNodeNamesOrValuesAndNodeKeys(newRtx, oldRtx)) continue;
                    found = FoundMatchingNode.TRUE;
                }
                oldRtx.moveTo(oldKey);
                diff = found.kindOfDiff();
            }
            this.diff = diff;
            this.emitDiffs(diff);
        }
        assert (diff != null);
        return diff;
    }

    private void emitDiffs(DiffFactory.DiffType diff) {
        R rtx;
        Revision revision = diff == DiffFactory.DiffType.DELETED ? Revision.OLD : Revision.NEW;
        int depth = diff == DiffFactory.DiffType.DELETED ? this.depth.getOldDepth() : this.depth.getNewDepth();
        R r = rtx = diff == DiffFactory.DiffType.DELETED ? this.oldRtx : this.newRtx;
        if (this.skipSubtrees) {
            DiffDepth diffDepth = new DiffDepth(this.depth.getNewDepth(), this.depth.getOldDepth());
            this.fireDiff(diff, this.newRtx.getNodeKey(), this.oldRtx.getNodeKey(), diffDepth);
            this.emitNonStructuralDiff(this.newRtx, this.oldRtx, diffDepth, diff);
            this.moveToFollowingNode(rtx, revision);
        } else {
            do {
                DiffDepth diffDepth = new DiffDepth(this.depth.getNewDepth(), this.depth.getOldDepth());
                this.fireDiff(diff, this.newRtx.getNodeKey(), this.oldRtx.getNodeKey(), diffDepth);
                this.emitNonStructuralDiff(this.newRtx, this.oldRtx, diffDepth, diff);
            } while (this.moveCursor(rtx, revision, Move.DOCUMENT_ORDER) && (diff == DiffFactory.DiffType.INSERTED && this.depth.getNewDepth() > depth || diff == DiffFactory.DiffType.DELETED && this.depth.getOldDepth() > depth));
        }
    }

    abstract boolean checkNodes(R var1, R var2);

    private boolean checkNodeNamesOrValuesAndNodeKeys(R newRtx, R oldRtx) {
        return newRtx.getNodeKey() == oldRtx.getNodeKey() && this.checkNodeNamesOrValues(newRtx, oldRtx);
    }

    abstract void emitNonStructuralDiff(R var1, R var2, DiffDepth var3, DiffFactory.DiffType var4);

    boolean checkReplace(R newRtx, R oldRtx) {
        boolean replaced = false;
        if (newRtx.getNodeKey() != oldRtx.getNodeKey()) {
            long newKey = newRtx.getNodeKey();
            boolean movedNewRtx = ((NodeCursor)newRtx).moveToRightSibling();
            long oldKey = oldRtx.getNodeKey();
            boolean movedOldRtx = ((NodeCursor)oldRtx).moveToRightSibling();
            if (movedNewRtx && movedOldRtx && newRtx.getNodeKey() == oldRtx.getNodeKey()) {
                replaced = true;
            } else if (!(movedNewRtx || movedOldRtx || this.diff != DiffFactory.DiffType.SAME && this.diff != DiffFactory.DiffType.SAMEHASH)) {
                movedNewRtx = ((NodeCursor)newRtx).moveToParent();
                movedOldRtx = ((NodeCursor)oldRtx).moveToParent();
                if (movedNewRtx && movedOldRtx && newRtx.getNodeKey() == oldRtx.getNodeKey()) {
                    replaced = true;
                }
            }
            newRtx.moveTo(newKey);
            oldRtx.moveTo(oldKey);
            if (replaced) {
                if (this.skipSubtrees) {
                    DiffDepth diffDepth = new DiffDepth(this.depth.getNewDepth(), this.depth.getOldDepth());
                    this.fireDiff(DiffFactory.DiffType.REPLACEDOLD, newRtx.getNodeKey(), oldRtx.getNodeKey(), diffDepth);
                    this.fireDiff(DiffFactory.DiffType.REPLACEDNEW, newRtx.getNodeKey(), oldRtx.getNodeKey(), diffDepth);
                    this.emitNonStructuralDiff(newRtx, oldRtx, diffDepth, DiffFactory.DiffType.REPLACEDOLD);
                } else {
                    DiffDepth diffDepth;
                    long newNodeKey = newRtx.getNodeKey();
                    long oldNodeKey = oldRtx.getNodeKey();
                    DescendantAxis oldAxis = new DescendantAxis((NodeCursor)oldRtx, IncludeSelf.YES);
                    DescendantAxis newAxis = new DescendantAxis((NodeCursor)newRtx, IncludeSelf.YES);
                    while (oldAxis.hasNext()) {
                        oldAxis.nextLong();
                        diffDepth = new DiffDepth(this.depth.getNewDepth(), this.depth.getOldDepth());
                        this.fireDiff(DiffFactory.DiffType.REPLACEDOLD, newRtx.getNodeKey(), oldRtx.getNodeKey(), diffDepth);
                        this.emitNonStructuralDiff(newRtx, oldRtx, diffDepth, DiffFactory.DiffType.REPLACEDOLD);
                        this.adjustDepth(oldRtx, oldNodeKey, Revision.OLD);
                    }
                    while (newAxis.hasNext()) {
                        newAxis.nextLong();
                        diffDepth = new DiffDepth(this.depth.getNewDepth(), this.depth.getOldDepth());
                        this.fireDiff(DiffFactory.DiffType.REPLACEDNEW, newRtx.getNodeKey(), oldRtx.getNodeKey(), diffDepth);
                        this.emitNonStructuralDiff(newRtx, oldRtx, diffDepth, DiffFactory.DiffType.REPLACEDNEW);
                        this.adjustDepth(newRtx, newNodeKey, Revision.NEW);
                    }
                    newRtx.moveTo(newNodeKey);
                    oldRtx.moveTo(oldNodeKey);
                    this.diff = DiffFactory.DiffType.REPLACED;
                }
            }
        }
        return replaced;
    }

    private void adjustDepth(R rtx, @NonNegative long startNodeKey, Revision revision) {
        assert (rtx != null);
        assert (revision != null);
        long nodeKey = rtx.getNodeKey();
        if (((NodeCursor)rtx).hasFirstChild()) {
            switch (revision.ordinal()) {
                case 1: {
                    this.depth.incrementNewDepth();
                    break;
                }
                case 0: {
                    this.depth.incrementOldDepth();
                    break;
                }
            }
        } else {
            block8: while (!((NodeCursor)rtx).hasRightSibling() && ((NodeCursor)rtx).hasParent() && rtx.getNodeKey() != startNodeKey) {
                ((NodeCursor)rtx).moveToParent();
                switch (revision.ordinal()) {
                    case 1: {
                        this.depth.decrementNewDepth();
                        continue block8;
                    }
                    case 0: {
                        this.depth.decrementOldDepth();
                        continue block8;
                    }
                }
            }
        }
        rtx.moveTo(nodeKey);
    }

    boolean checkUpdate(R newRtx, R oldRtx) {
        if (this.isFirst) {
            return newRtx.getNodeKey() == oldRtx.getNodeKey();
        }
        return newRtx.getNodeKey() == oldRtx.getNodeKey() && ((NodeCursor)newRtx).getParentKey() == ((NodeCursor)oldRtx).getParentKey() && this.depth.getNewDepth() == this.depth.getOldDepth();
    }

    abstract boolean checkNodeNamesOrValues(R var1, R var2);

    abstract NodeKind documentNode();

    private static enum Revision {
        OLD,
        NEW;

    }

    private static enum Move {
        FOLLOWING,
        DOCUMENT_ORDER;

    }
}

