/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.diff;

import io.sirix.diff.DiffDepth;
import io.sirix.diff.DiffFactory;
import io.sirix.diff.DiffObservable;
import io.sirix.diff.DiffObserver;
import io.sirix.exception.SirixException;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

abstract class AbstractDiffObservable
implements DiffObservable {
    private final Set<DiffObserver> diffObservers = new HashSet<DiffObserver>();

    AbstractDiffObservable() {
    }

    @Override
    public final void fireDiff(DiffFactory.DiffType diff, @NonNull long newNodeKey, @NonNull long oldNodeKey, @NonNull DiffDepth depth) {
        for (DiffObserver observer : this.diffObservers) {
            observer.diffListener(diff, newNodeKey, oldNodeKey, depth);
        }
    }

    @Override
    public final void done() throws SirixException {
        for (DiffObserver observer : this.diffObservers) {
            observer.diffDone();
        }
    }

    @Override
    public final void addObserver(DiffObserver observer) {
        this.diffObservers.add(observer);
    }

    @Override
    public final void removeObserver(DiffObserver observer) {
        this.diffObservers.remove(observer);
    }
}

