/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.diff;

import com.google.common.base.Preconditions;
import io.sirix.access.trx.node.HashType;
import io.sirix.api.NodeCursor;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.api.NodeTrx;
import io.sirix.api.ResourceSession;
import io.sirix.api.json.JsonNodeReadOnlyTrx;
import io.sirix.api.json.JsonNodeTrx;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.api.xml.XmlNodeTrx;
import io.sirix.api.xml.XmlResourceSession;
import io.sirix.diff.DiffObserver;
import io.sirix.diff.JsonDiff;
import io.sirix.diff.XmlFullDiff;
import io.sirix.diff.XmlStructuralDiff;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.index.qual.NonNegative;

public final class DiffFactory {
    public static Builder<XmlNodeReadOnlyTrx, XmlNodeTrx> builder(XmlResourceSession resourceManager, @NonNegative int newRev, @NonNegative int oldRev, DiffOptimized diffKind, Set<DiffObserver> observers) {
        return new Builder<XmlNodeReadOnlyTrx, XmlNodeTrx>(resourceManager, newRev, oldRev, diffKind, observers);
    }

    private DiffFactory() {
        throw new AssertionError((Object)"No instantiation allowed!");
    }

    public static synchronized void invokeJsonDiff(Builder<JsonNodeReadOnlyTrx, JsonNodeTrx> builder) {
        DiffAlgorithm.JSON.invoke(builder);
    }

    public static synchronized void invokeFullXmlDiff(Builder<XmlNodeReadOnlyTrx, XmlNodeTrx> builder) {
        DiffAlgorithm.XML_FULL.invoke(builder);
    }

    public static synchronized void invokeStructuralXmlDiff(Builder<XmlNodeReadOnlyTrx, XmlNodeTrx> builder) {
        DiffAlgorithm.XML_STRUCTURAL.invoke(builder);
    }

    public static final class Builder<R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor> {
        final ResourceSession<R, W> resMgr;
        transient long newStartKey;
        transient long oldStartKey;
        final int newRev;
        final int oldRev;
        transient int newDepth;
        transient int oldDepth;
        final DiffOptimized kind;
        final Set<DiffObserver> observers;
        transient DiffAlgorithm mDiffKind;
        transient HashType hashKind = HashType.ROLLING;
        transient boolean isGUI = true;
        transient boolean skipSubtrees = false;
        transient long oldMaxDepth;

        public Builder(ResourceSession<R, W> resMgr, @NonNegative int newRev, @NonNegative int oldRev, DiffOptimized diffKind, Set<DiffObserver> observers) {
            this.resMgr = Objects.requireNonNull(resMgr);
            Preconditions.checkArgument((newRev >= 0 ? 1 : 0) != 0, (Object)"paramNewRev must be >= 0!");
            this.newRev = newRev;
            Preconditions.checkArgument((oldRev >= 0 ? 1 : 0) != 0, (Object)"paramOldRev must be >= 0!");
            this.oldRev = oldRev;
            this.kind = Objects.requireNonNull(diffKind);
            this.observers = Objects.requireNonNull(observers);
        }

        public Builder<R, W> isGUI(boolean isGUI) {
            this.isGUI = isGUI;
            return this;
        }

        public Builder<R, W> oldStartKey(@NonNegative long oldKey) {
            Preconditions.checkArgument((oldKey >= 0L ? 1 : 0) != 0, (Object)"oldKey must be >= 0!");
            this.oldStartKey = oldKey;
            return this;
        }

        public Builder<R, W> oldMaxDepth(@NonNegative long oldMaxDepth) {
            Preconditions.checkArgument((oldMaxDepth >= 0L ? 1 : 0) != 0, (Object)"oldMaxDepth must be >= 0!");
            this.oldMaxDepth = oldMaxDepth;
            return this;
        }

        public Builder<R, W> newStartKey(@NonNegative long newKey) {
            Preconditions.checkArgument((newKey >= 0L ? 1 : 0) != 0, (Object)"newKey must be >= 0!");
            this.newStartKey = newKey;
            return this;
        }

        public Builder<R, W> newDepth(@NonNegative int newDepth) {
            Preconditions.checkArgument((newDepth >= 0 ? 1 : 0) != 0, (Object)"newDepth must be >= 0!");
            this.newDepth = newDepth;
            return this;
        }

        public Builder<R, W> oldDepth(int oldDepth) {
            Preconditions.checkArgument((oldDepth >= 0 ? 1 : 0) != 0, (Object)"oldDepth must be >= 0!");
            this.oldDepth = oldDepth;
            return this;
        }

        public Builder<R, W> diffAlgorithm(DiffAlgorithm diffAlgorithm) {
            this.mDiffKind = Objects.requireNonNull(diffAlgorithm);
            return this;
        }

        public Builder<R, W> hashKind(HashType kind) {
            this.hashKind = Objects.requireNonNull(kind);
            return this;
        }

        public Builder<R, W> skipSubtrees(boolean skipSubtrees) {
            this.skipSubtrees = skipSubtrees;
            return this;
        }
    }

    public static enum DiffOptimized {
        NO,
        HASHED;

    }

    private static enum DiffAlgorithm {
        XML_FULL{

            @Override
            <R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor> void invoke(Builder<R, W> builder) {
                Builder<XmlNodeReadOnlyTrx, XmlNodeTrx> xmlDiffBuilder = builder;
                new XmlFullDiff(xmlDiffBuilder).diffMovement();
            }
        }
        ,
        XML_STRUCTURAL{

            @Override
            <R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor> void invoke(Builder<R, W> builder) {
                Builder<XmlNodeReadOnlyTrx, XmlNodeTrx> xmlDiffBuilder = builder;
                new XmlStructuralDiff(xmlDiffBuilder).diffMovement();
            }
        }
        ,
        JSON{

            @Override
            <R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor> void invoke(Builder<R, W> builder) {
                Builder<JsonNodeReadOnlyTrx, JsonNodeTrx> jsonDiffBuilder = builder;
                new JsonDiff(jsonDiffBuilder).diffMovement();
            }
        };


        abstract <R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor> void invoke(Builder<R, W> var1);
    }

    public static enum DiffType {
        SAME,
        SAMEHASH,
        INSERTED,
        DELETED,
        UPDATED,
        REPLACED,
        REPLACEDNEW,
        REPLACEDOLD,
        MOVEDFROM,
        MOVEDTO;

    }
}

