/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.diff;

import com.google.api.client.util.Objects;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.sirix.api.json.JsonNodeReadOnlyTrx;
import io.sirix.api.json.JsonResourceSession;
import io.sirix.diff.DiffFactory;
import io.sirix.diff.DiffTuple;
import io.sirix.node.NodeKind;
import io.sirix.node.SirixDeweyID;
import io.sirix.service.json.serialize.JsonSerializer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.util.Collection;

public final class JsonDiffSerializer {
    private final String databaseName;
    private final JsonResourceSession resourceManager;
    private final int oldRevisionNumber;
    private final int newRevisionNumber;
    private final Collection<DiffTuple> diffs;

    public JsonDiffSerializer(String databaseName, JsonResourceSession resourceManager, int oldRevisionNumber, int newRevisionNumber, Collection<DiffTuple> diffs) {
        this.databaseName = databaseName;
        this.resourceManager = resourceManager;
        this.oldRevisionNumber = oldRevisionNumber;
        this.newRevisionNumber = newRevisionNumber;
        this.diffs = diffs;
    }

    public String serialize(boolean emitFromDiffAlgorithm) {
        DiffTuple tuple;
        String resourceName = this.resourceManager.getResourceConfig().getName();
        JsonObject json = this.createMetaInfo(this.databaseName, resourceName, this.oldRevisionNumber, this.newRevisionNumber);
        if (this.diffs.size() == 1 && ((tuple = this.diffs.iterator().next()).getDiff() == DiffFactory.DiffType.SAME || tuple.getDiff() == DiffFactory.DiffType.SAMEHASH)) {
            return json.toString();
        }
        JsonArray jsonDiffs = json.getAsJsonArray("diffs");
        try (JsonNodeReadOnlyTrx oldRtx = (JsonNodeReadOnlyTrx)this.resourceManager.beginNodeReadOnlyTrx(this.oldRevisionNumber);
             JsonNodeReadOnlyTrx newRtx = (JsonNodeReadOnlyTrx)this.resourceManager.beginNodeReadOnlyTrx(this.newRevisionNumber);){
            if (emitFromDiffAlgorithm) {
                this.diffs.removeIf(diffTuple -> diffTuple.getDiff() == DiffFactory.DiffType.SAME || diffTuple.getDiff() == DiffFactory.DiffType.SAMEHASH || diffTuple.getDiff() == DiffFactory.DiffType.REPLACEDOLD);
            }
            if (this.diffs.isEmpty()) {
                String string = json.toString();
                return string;
            }
            for (DiffTuple diffTuple2 : this.diffs) {
                DiffFactory.DiffType diffType = diffTuple2.getDiff();
                if (diffType == DiffFactory.DiffType.INSERTED) {
                    newRtx.moveTo(diffTuple2.getNewNodeKey());
                } else if (diffType == DiffFactory.DiffType.DELETED) {
                    oldRtx.moveTo(diffTuple2.getOldNodeKey());
                } else {
                    newRtx.moveTo(diffTuple2.getNewNodeKey());
                    oldRtx.moveTo(diffTuple2.getOldNodeKey());
                }
                switch (diffType) {
                    case INSERTED: {
                        JsonObject insertedJson = new JsonObject();
                        JsonObject jsonInsertDiff = new JsonObject();
                        this.insertBasedOnNewRtx(newRtx, jsonInsertDiff);
                        if (this.resourceManager.getResourceConfig().areDeweyIDsStored) {
                            SirixDeweyID deweyId = newRtx.getDeweyID();
                            jsonInsertDiff.addProperty("deweyID", deweyId.toString());
                            jsonInsertDiff.addProperty("depth", (Number)deweyId.getLevel());
                        }
                        this.addTypeAndDataProperties(newRtx, jsonInsertDiff, this.newRevisionNumber, emitFromDiffAlgorithm);
                        insertedJson.add("insert", (JsonElement)jsonInsertDiff);
                        jsonDiffs.add((JsonElement)insertedJson);
                        break;
                    }
                    case DELETED: {
                        JsonObject deletedJson = new JsonObject();
                        if (this.resourceManager.getResourceConfig().areDeweyIDsStored) {
                            JsonObject jsonDeletedDiff = new JsonObject();
                            jsonDeletedDiff.addProperty("nodeKey", (Number)diffTuple2.getOldNodeKey());
                            SirixDeweyID deweyId = oldRtx.getDeweyID();
                            jsonDeletedDiff.addProperty("deweyID", deweyId.toString());
                            jsonDeletedDiff.addProperty("depth", (Number)deweyId.getLevel());
                            deletedJson.add("delete", (JsonElement)jsonDeletedDiff);
                        } else {
                            deletedJson.addProperty("delete", (Number)diffTuple2.getOldNodeKey());
                        }
                        jsonDiffs.add((JsonElement)deletedJson);
                        break;
                    }
                    case REPLACEDNEW: {
                        JsonObject replaceJson = new JsonObject();
                        JsonObject jsonReplaceDiff = new JsonObject();
                        replaceJson.add("replace", (JsonElement)jsonReplaceDiff);
                        jsonReplaceDiff.addProperty("oldNodeKey", (Number)diffTuple2.getOldNodeKey());
                        jsonReplaceDiff.addProperty("newNodeKey", (Number)diffTuple2.getNewNodeKey());
                        if (this.resourceManager.getResourceConfig().areDeweyIDsStored) {
                            SirixDeweyID deweyId = newRtx.getDeweyID();
                            jsonReplaceDiff.addProperty("deweyID", deweyId.toString());
                            jsonReplaceDiff.addProperty("depth", (Number)deweyId.getLevel());
                        }
                        this.addTypeAndDataProperties(newRtx, jsonReplaceDiff, this.newRevisionNumber, emitFromDiffAlgorithm);
                        jsonDiffs.add((JsonElement)replaceJson);
                        break;
                    }
                    case UPDATED: {
                        JsonObject updateJson = new JsonObject();
                        JsonObject jsonUpdateDiff = new JsonObject();
                        jsonUpdateDiff.addProperty("nodeKey", (Number)diffTuple2.getOldNodeKey());
                        if (this.resourceManager.getResourceConfig().areDeweyIDsStored) {
                            SirixDeweyID deweyId = newRtx.getDeweyID();
                            jsonUpdateDiff.addProperty("deweyID", deweyId.toString());
                            jsonUpdateDiff.addProperty("depth", (Number)deweyId.getLevel());
                        }
                        if (!Objects.equal((Object)oldRtx.getName(), (Object)newRtx.getName())) {
                            jsonUpdateDiff.addProperty("name", newRtx.getName().toString());
                        } else if (!Objects.equal((Object)oldRtx.getValue(), (Object)newRtx.getValue())) {
                            if (newRtx.getKind() == NodeKind.BOOLEAN_VALUE || newRtx.getKind() == NodeKind.OBJECT_BOOLEAN_VALUE) {
                                jsonUpdateDiff.addProperty("type", "boolean");
                                jsonUpdateDiff.addProperty("value", Boolean.valueOf(newRtx.getBooleanValue()));
                            } else if (newRtx.getKind() == NodeKind.STRING_VALUE || newRtx.getKind() == NodeKind.OBJECT_STRING_VALUE) {
                                jsonUpdateDiff.addProperty("type", "string");
                                jsonUpdateDiff.addProperty("value", newRtx.getValue());
                            } else if (newRtx.getKind() == NodeKind.NULL_VALUE || newRtx.getKind() == NodeKind.OBJECT_NULL_VALUE) {
                                jsonUpdateDiff.addProperty("type", "null");
                                jsonUpdateDiff.add("value", null);
                            } else if (newRtx.getKind() == NodeKind.NUMBER_VALUE || newRtx.getKind() == NodeKind.OBJECT_NUMBER_VALUE) {
                                jsonUpdateDiff.addProperty("type", "number");
                                jsonUpdateDiff.addProperty("value", newRtx.getNumberValue());
                            }
                        }
                        updateJson.add("update", (JsonElement)jsonUpdateDiff);
                        jsonDiffs.add((JsonElement)updateJson);
                    }
                }
            }
        }
        return json.toString();
    }

    private void insertBasedOnNewRtx(JsonNodeReadOnlyTrx newRtx, JsonObject jsonInsertDiff) {
        jsonInsertDiff.addProperty("nodeKey", (Number)newRtx.getNodeKey());
        String insertPosition = newRtx.hasLeftSibling() ? "asRightSibling" : "asFirstChild";
        jsonInsertDiff.addProperty("insertPositionNodeKey", (Number)(newRtx.hasLeftSibling() ? newRtx.getLeftSiblingKey() : newRtx.getParentKey()));
        jsonInsertDiff.addProperty("insertPosition", insertPosition);
    }

    private JsonObject createMetaInfo(String databaseName, String resourceName, int oldRevision, int newRevision) {
        JsonObject json = new JsonObject();
        json.addProperty("database", databaseName);
        json.addProperty("resource", resourceName);
        json.addProperty("old-revision", (Number)oldRevision);
        json.addProperty("new-revision", (Number)newRevision);
        JsonArray diffsArray = new JsonArray();
        json.add("diffs", (JsonElement)diffsArray);
        return json;
    }

    private void addTypeAndDataProperties(JsonNodeReadOnlyTrx newRtx, JsonObject json, int newRevisionNumber, boolean emitFromDiffAlgorithm) {
        if (newRtx.isArray() || newRtx.isObject() || newRtx.isObjectKey()) {
            json.addProperty("type", "jsonFragment");
            if (emitFromDiffAlgorithm) {
                JsonDiffSerializer.serialize(newRevisionNumber, this.resourceManager, newRtx, json);
            }
        } else if (newRtx.getKind() == NodeKind.BOOLEAN_VALUE || newRtx.getKind() == NodeKind.OBJECT_BOOLEAN_VALUE) {
            json.addProperty("type", "boolean");
            json.addProperty("data", Boolean.valueOf(newRtx.getBooleanValue()));
        } else if (newRtx.getKind() == NodeKind.STRING_VALUE || newRtx.getKind() == NodeKind.OBJECT_STRING_VALUE) {
            json.addProperty("type", "string");
            json.addProperty("data", newRtx.getValue());
        } else if (newRtx.getKind() == NodeKind.NULL_VALUE || newRtx.getKind() == NodeKind.OBJECT_NULL_VALUE) {
            json.addProperty("type", "null");
            json.add("data", null);
        } else if (newRtx.getKind() == NodeKind.NUMBER_VALUE || newRtx.getKind() == NodeKind.OBJECT_NUMBER_VALUE) {
            json.addProperty("type", "number");
            json.addProperty("data", newRtx.getNumberValue());
        }
    }

    public static void serialize(int newRevision, JsonResourceSession resourceManager, JsonNodeReadOnlyTrx newRtx, JsonObject jsonObject) {
        try (StringWriter writer = new StringWriter();){
            JsonSerializer serializer = JsonSerializer.newBuilder(resourceManager, writer, newRevision).startNodeKey(newRtx.getNodeKey()).build();
            serializer.call();
            jsonObject.addProperty("data", writer.toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

