/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.diff;

import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.api.xml.XmlNodeTrx;
import io.sirix.diff.AbstractDiff;
import io.sirix.diff.DiffDepth;
import io.sirix.diff.DiffFactory;
import io.sirix.exception.SirixException;
import io.sirix.node.NodeKind;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;

final class XmlFullDiff
extends AbstractDiff<XmlNodeReadOnlyTrx, XmlNodeTrx> {
    XmlFullDiff(DiffFactory.Builder<XmlNodeReadOnlyTrx, XmlNodeTrx> builder) throws SirixException {
        super(builder);
    }

    @Override
    NodeKind documentNode() {
        return NodeKind.XML_DOCUMENT;
    }

    @Override
    boolean checkNodes(XmlNodeReadOnlyTrx newRtx, XmlNodeReadOnlyTrx oldRtx) {
        boolean found = false;
        if (newRtx.getNodeKey() == oldRtx.getNodeKey() && newRtx.getParentKey() == oldRtx.getParentKey() && newRtx.getKind() == oldRtx.getKind()) {
            switch (newRtx.getKind()) {
                case ELEMENT: {
                    if (!this.checkNamesForEquality(newRtx, oldRtx) || !newRtx.getAttributeKeys().equals(oldRtx.getAttributeKeys()) || !newRtx.getNamespaceKeys().equals(oldRtx.getNamespaceKeys())) break;
                    found = true;
                    long newNodeKey = newRtx.getNodeKey();
                    long oldNodeKey = oldRtx.getNodeKey();
                    for (long nsp : newRtx.getNamespaceKeys()) {
                        newRtx.moveTo(nsp);
                        oldRtx.moveTo(nsp);
                        if (this.checkNamesForEquality(newRtx, oldRtx)) continue;
                        found = false;
                        break;
                    }
                    newRtx.moveTo(newNodeKey);
                    oldRtx.moveTo(oldNodeKey);
                    if (!found) break;
                    for (long attr : newRtx.getAttributeKeys()) {
                        newRtx.moveTo(attr);
                        oldRtx.moveTo(attr);
                        if (this.checkNamesForEquality(newRtx, oldRtx) && Objects.equals(newRtx.getValue(), oldRtx.getValue())) continue;
                        found = false;
                        break;
                    }
                    newRtx.moveTo(newNodeKey);
                    oldRtx.moveTo(oldNodeKey);
                    break;
                }
                case PROCESSING_INSTRUCTION: {
                    found = newRtx.getValue().equals(oldRtx.getValue()) && this.checkNamesForEquality(newRtx, oldRtx);
                    break;
                }
                case TEXT: 
                case COMMENT: {
                    found = newRtx.getValue().equals(oldRtx.getValue());
                    break;
                }
                default: {
                    throw new IllegalStateException("Other node types currently not supported!");
                }
            }
        }
        return found;
    }

    @Override
    void emitNonStructuralDiff(XmlNodeReadOnlyTrx newRtx, XmlNodeReadOnlyTrx oldRtx, DiffDepth depth, DiffFactory.DiffType diff) {
        block14: {
            int i;
            block17: {
                int i2;
                block16: {
                    long newNodeKey;
                    int i3;
                    block15: {
                        if (!newRtx.isElement() && !oldRtx.isElement()) break block14;
                        if (diff != DiffFactory.DiffType.UPDATED) break block15;
                        long newNodeKey2 = newRtx.getNodeKey();
                        long oldNodeKey = oldRtx.getNodeKey();
                        ArrayList<Long> insertedNamespaces = new ArrayList<Long>(newRtx.getNamespaceKeys());
                        insertedNamespaces.removeAll(oldRtx.getNamespaceKeys());
                        Iterator iterator = insertedNamespaces.iterator();
                        while (iterator.hasNext()) {
                            long nsp = (Long)iterator.next();
                            newRtx.moveTo(nsp);
                            this.fireDiff(DiffFactory.DiffType.INSERTED, newRtx.getNodeKey(), oldRtx.getNodeKey(), depth);
                        }
                        newRtx.moveTo(newNodeKey2);
                        ArrayList<Long> removedNamespaces = new ArrayList<Long>(oldRtx.getNamespaceKeys());
                        removedNamespaces.removeAll(newRtx.getNamespaceKeys());
                        Iterator nsp = removedNamespaces.iterator();
                        while (nsp.hasNext()) {
                            long nsp2 = (Long)nsp.next();
                            oldRtx.moveTo(nsp2);
                            this.fireDiff(DiffFactory.DiffType.DELETED, newRtx.getNodeKey(), oldRtx.getNodeKey(), depth);
                        }
                        oldRtx.moveTo(oldNodeKey);
                        ArrayList<Long> insertedAttributes = new ArrayList<Long>(newRtx.getAttributeKeys());
                        insertedAttributes.removeAll(oldRtx.getAttributeKeys());
                        Iterator nsp2 = insertedAttributes.iterator();
                        while (nsp2.hasNext()) {
                            long attribute = (Long)nsp2.next();
                            newRtx.moveTo(attribute);
                            this.fireDiff(DiffFactory.DiffType.INSERTED, newRtx.getNodeKey(), oldRtx.getNodeKey(), depth);
                        }
                        newRtx.moveTo(newNodeKey2);
                        ArrayList<Long> removedAttributes = new ArrayList<Long>(oldRtx.getAttributeKeys());
                        removedAttributes.removeAll(newRtx.getAttributeKeys());
                        Iterator attribute = removedAttributes.iterator();
                        while (attribute.hasNext()) {
                            long attribute2 = (Long)attribute.next();
                            oldRtx.moveTo(attribute2);
                            this.fireDiff(DiffFactory.DiffType.DELETED, newRtx.getNodeKey(), oldRtx.getNodeKey(), depth);
                        }
                        oldRtx.moveTo(oldNodeKey);
                        ArrayList<Long> sameNamespaces = new ArrayList<Long>(newRtx.getNamespaceKeys());
                        sameNamespaces.retainAll(oldRtx.getNamespaceKeys());
                        Iterator attribute2 = sameNamespaces.iterator();
                        while (attribute2.hasNext()) {
                            long nsp3 = (Long)attribute2.next();
                            newRtx.moveTo(nsp3);
                            oldRtx.moveTo(nsp3);
                            if (newRtx.getName().equals((Object)oldRtx.getName())) {
                                this.fireDiff(DiffFactory.DiffType.SAME, newRtx.getNodeKey(), oldRtx.getNodeKey(), depth);
                                continue;
                            }
                            this.fireDiff(DiffFactory.DiffType.UPDATED, newRtx.getNodeKey(), oldRtx.getNodeKey(), depth);
                        }
                        newRtx.moveTo(newNodeKey2);
                        oldRtx.moveTo(oldNodeKey);
                        ArrayList<Long> sameAttributes = new ArrayList<Long>(newRtx.getAttributeKeys());
                        sameAttributes.retainAll(oldRtx.getAttributeKeys());
                        Iterator iterator2 = sameAttributes.iterator();
                        while (iterator2.hasNext()) {
                            long attr = (Long)iterator2.next();
                            newRtx.moveTo(attr);
                            oldRtx.moveTo(attr);
                            if (this.checkNamesForEquality(newRtx, oldRtx) && Objects.equals(newRtx.getValue(), oldRtx.getValue())) {
                                this.fireDiff(DiffFactory.DiffType.SAME, newRtx.getNodeKey(), oldRtx.getNodeKey(), depth);
                                continue;
                            }
                            this.fireDiff(DiffFactory.DiffType.UPDATED, newRtx.getNodeKey(), oldRtx.getNodeKey(), depth);
                        }
                        newRtx.moveTo(newNodeKey2);
                        oldRtx.moveTo(oldNodeKey);
                        break block14;
                    }
                    if (diff != DiffFactory.DiffType.SAME) break block16;
                    int nspCount = newRtx.getNamespaceCount();
                    for (i3 = 0; i3 < nspCount; ++i3) {
                        newRtx.moveToNamespace(i3);
                        newNodeKey = newRtx.getNodeKey();
                        oldRtx.moveTo(newNodeKey);
                        this.fireDiff(diff, newRtx.getNodeKey(), oldRtx.getNodeKey(), depth);
                        newRtx.moveToParent();
                        oldRtx.moveToParent();
                    }
                    int attCount = newRtx.getAttributeCount();
                    for (i3 = 0; i3 < attCount; ++i3) {
                        newRtx.moveToAttribute(i3);
                        newNodeKey = newRtx.getNodeKey();
                        oldRtx.moveTo(newNodeKey);
                        this.fireDiff(diff, newRtx.getNodeKey(), oldRtx.getNodeKey(), depth);
                        newRtx.moveToParent();
                        oldRtx.moveToParent();
                    }
                    break block14;
                }
                if (diff != DiffFactory.DiffType.DELETED) break block17;
                int nspCount = oldRtx.getNamespaceCount();
                for (i2 = 0; i2 < nspCount; ++i2) {
                    oldRtx.moveToNamespace(i2);
                    this.fireDiff(diff, newRtx.getNodeKey(), oldRtx.getNodeKey(), depth);
                    oldRtx.moveToParent();
                }
                int attCount = oldRtx.getAttributeCount();
                for (i2 = 0; i2 < attCount; ++i2) {
                    oldRtx.moveToAttribute(i2);
                    this.fireDiff(diff, newRtx.getNodeKey(), oldRtx.getNodeKey(), depth);
                    oldRtx.moveToParent();
                }
                break block14;
            }
            if (diff != DiffFactory.DiffType.INSERTED) break block14;
            int nspCount = newRtx.getNamespaceCount();
            for (i = 0; i < nspCount; ++i) {
                newRtx.moveToNamespace(i);
                this.fireDiff(diff, newRtx.getNodeKey(), oldRtx.getNodeKey(), depth);
                newRtx.moveToParent();
            }
            int attCount = newRtx.getAttributeCount();
            for (i = 0; i < attCount; ++i) {
                newRtx.moveToAttribute(i);
                this.fireDiff(diff, newRtx.getNodeKey(), oldRtx.getNodeKey(), depth);
                newRtx.moveToParent();
            }
        }
    }

    @Override
    boolean checkNodeNamesOrValues(XmlNodeReadOnlyTrx newRtx, XmlNodeReadOnlyTrx oldRtx) {
        boolean found = false;
        if (newRtx.getKind() == oldRtx.getKind()) {
            switch (newRtx.getKind()) {
                case ELEMENT: 
                case PROCESSING_INSTRUCTION: {
                    if (!this.checkNamesForEquality(newRtx, oldRtx)) break;
                    found = true;
                    break;
                }
                case TEXT: 
                case COMMENT: {
                    if (!newRtx.getValue().equals(oldRtx.getValue())) break;
                    found = true;
                    break;
                }
            }
        }
        return found;
    }

    private boolean checkNamesForEquality(XmlNodeReadOnlyTrx newRtx, XmlNodeReadOnlyTrx oldRtx) {
        return newRtx.getURIKey() == oldRtx.getURIKey() && newRtx.getLocalNameKey() == oldRtx.getLocalNameKey() && newRtx.getPrefixKey() == oldRtx.getPrefixKey();
    }
}

