/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.diff.algorithm.fmse;

import io.brackit.query.atomic.QNm;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.api.visitor.XmlNodeVisitor;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.api.xml.XmlNodeTrx;
import io.sirix.axis.ChildAxis;
import io.sirix.axis.DescendantAxis;
import io.sirix.axis.IncludeSelf;
import io.sirix.axis.LevelOrderAxis;
import io.sirix.axis.PostOrderAxis;
import io.sirix.axis.visitor.DeleteFMSEVisitor;
import io.sirix.axis.visitor.VisitorDescendantAxis;
import io.sirix.diff.algorithm.ImportDiff;
import io.sirix.diff.algorithm.fmse.FMSENodeComparisonUtils;
import io.sirix.diff.algorithm.fmse.FMSEVisitor;
import io.sirix.diff.algorithm.fmse.LabelFMSEVisitor;
import io.sirix.diff.algorithm.fmse.LeafNodeComparator;
import io.sirix.diff.algorithm.fmse.Matching;
import io.sirix.diff.algorithm.fmse.NodeComparator;
import io.sirix.diff.algorithm.fmse.NodeComparisonFactory;
import io.sirix.diff.algorithm.fmse.Util;
import io.sirix.exception.SirixException;
import io.sirix.exception.SirixUsageException;
import io.sirix.index.path.summary.PathSummaryReader;
import io.sirix.node.NodeKind;
import io.sirix.utils.LogWrapper;
import io.sirix.utils.Pair;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.LoggerFactory;

public final class FMSE
implements ImportDiff,
AutoCloseable {
    private static final LogWrapper logger = new LogWrapper(LoggerFactory.getLogger(FMSE.class));
    private static final String NAME = "Fast Matching / Edit Script";
    private Map<Long, Boolean> alreadyInserted;
    private transient Matching totalMatching;
    private Map<Long, Boolean> inOrderOldRev;
    private Map<Long, Boolean> inOrderNewRev;
    private Map<Long, Long> descendantsOldRev;
    private Map<Long, Long> descendantsNewRev;
    private LabelFMSEVisitor labelOldRevVisitor;
    private LabelFMSEVisitor labelNewRevVisitor;
    private XmlNodeTrx wtx;
    private XmlNodeReadOnlyTrx rtx;
    private long oldStartKey;
    private long newStartKey;
    private final QNm idName;
    private PathSummaryReader oldPathSummary;
    private PathSummaryReader newPathSummary;
    private final NodeComparisonFactory nodeComparisonFactory;

    private FMSE(QNm idName, NodeComparisonFactory nodeComparisonFactory) {
        this.idName = idName;
        this.nodeComparisonFactory = Objects.requireNonNull(nodeComparisonFactory);
    }

    public static FMSE createWithIdentifier(QNm idName, NodeComparisonFactory nodeComparisonFactory) {
        return new FMSE(idName, nodeComparisonFactory);
    }

    public static FMSE createInstance(NodeComparisonFactory nodeComparisonFactory) {
        return new FMSE(null, nodeComparisonFactory);
    }

    @Override
    public void diff(XmlNodeTrx wtx, XmlNodeReadOnlyTrx rtx) {
        this.wtx = Objects.requireNonNull(wtx);
        this.rtx = Objects.requireNonNull(rtx);
        this.oldStartKey = this.wtx.getNodeKey();
        this.newStartKey = this.rtx.getNodeKey();
        this.descendantsOldRev = new HashMap<Long, Long>();
        this.descendantsNewRev = new HashMap<Long, Long>();
        this.inOrderOldRev = new HashMap<Long, Boolean>();
        this.inOrderNewRev = new HashMap<Long, Boolean>();
        this.alreadyInserted = new HashMap<Long, Boolean>();
        this.oldPathSummary = this.wtx.getPathSummary();
        this.newPathSummary = this.rtx.getResourceSession().openPathSummary(this.rtx.getRevisionNumber());
        FMSEVisitor oldRevVisitor = new FMSEVisitor(this.wtx, this.inOrderOldRev, this.descendantsOldRev);
        FMSEVisitor newRevVisitor = new FMSEVisitor(this.rtx, this.inOrderNewRev, this.descendantsNewRev);
        this.labelOldRevVisitor = new LabelFMSEVisitor(this.wtx);
        this.labelNewRevVisitor = new LabelFMSEVisitor(this.rtx);
        FMSE.init(this.wtx, oldRevVisitor);
        FMSE.init(this.rtx, newRevVisitor);
        Matching fastMatching = this.fastMatch(this.wtx, this.rtx);
        this.totalMatching = new Matching(fastMatching);
        this.firstFMESStep(this.wtx, this.rtx);
        try {
            this.secondFMESStep(this.wtx, this.rtx);
        }
        catch (SirixException e) {
            logger.error(e.getMessage(), e);
        }
    }

    private void firstFMESStep(XmlNodeTrx wtx, XmlNodeReadOnlyTrx rtx) {
        assert (wtx != null);
        assert (rtx != null);
        wtx.moveTo(this.oldStartKey);
        rtx.moveTo(this.newStartKey);
        LevelOrderAxis axis = new LevelOrderAxis.Builder(rtx).includeSelf().includeNonStructuralNodes().build();
        while (axis.hasNext()) {
            axis.nextLong();
            long nodeKey = axis.asXmlNodeReadTrx().getNodeKey();
            this.doFirstFSMEStep(wtx, rtx);
            axis.asXmlNodeReadTrx().moveTo(nodeKey);
        }
    }

    private void doFirstFSMEStep(XmlNodeTrx wtx, XmlNodeReadOnlyTrx rtx) {
        assert (wtx != null);
        assert (rtx != null);
        FMSENodeComparisonUtils nodeComparisonUtils = new FMSENodeComparisonUtils(this.oldStartKey, this.newStartKey, this.wtx, this.rtx);
        long key = rtx.getNodeKey();
        long x = rtx.getNodeKey();
        rtx.moveToParent();
        long y = rtx.getNodeKey();
        Long z = this.totalMatching.reversePartner(y);
        Long w = this.totalMatching.reversePartner(x);
        wtx.moveTo(this.oldStartKey);
        if (w == null) {
            assert (z != null);
            this.inOrderNewRev.put(x, true);
            int k = this.findPos(x, wtx, rtx);
            assert (k > -1);
            w = this.emitInsert(x, z, k, wtx, rtx);
        } else if (x != wtx.getNodeKey()) {
            if (wtx.moveTo(w) && rtx.moveTo(x) && wtx.getKind() == rtx.getKind() && (!nodeComparisonUtils.nodeValuesEqual(w, x, wtx, rtx) || rtx.isAttribute() && !rtx.getValue().equals(wtx.getValue()))) {
                FMSE.emitUpdate(w, x, wtx, rtx);
            }
            wtx.moveTo(w);
            wtx.moveToParent();
            long v = wtx.getNodeKey();
            if (!this.totalMatching.contains(v, y) && wtx.moveTo(w) && rtx.moveTo(x)) {
                assert (z != null);
                this.inOrderNewRev.put(x, true);
                rtx.moveTo(x);
                if (rtx.isNamespace() || rtx.isAttribute()) {
                    wtx.moveTo(w);
                    try {
                        this.totalMatching.remove(w);
                        wtx.remove();
                    }
                    catch (SirixException e) {
                        logger.error(e.getMessage(), e);
                    }
                    w = this.emitInsert(x, z, -1, wtx, rtx);
                } else {
                    int k = this.findPos(x, wtx, rtx);
                    assert (k > -1);
                    this.emitMove(w, z, k, wtx, rtx);
                }
            }
        }
        this.alignChildren(w, x, wtx, rtx);
        rtx.moveTo(key);
    }

    private void secondFMESStep(XmlNodeTrx wtx, NodeReadOnlyTrx rtx) throws SirixException {
        assert (wtx != null);
        assert (rtx != null);
        wtx.moveTo(this.oldStartKey);
        LongIterator longIterator = VisitorDescendantAxis.newBuilder(wtx).includeSelf().visitor(new DeleteFMSEVisitor(wtx, this.totalMatching, this.oldStartKey)).build().iterator();
        while (longIterator.hasNext()) {
            long l = (Long)longIterator.next();
        }
    }

    private void alignChildren(long w, long x, XmlNodeTrx wtx, XmlNodeReadOnlyTrx rtx) {
        assert (w >= 0L);
        assert (x >= 0L);
        assert (wtx != null);
        assert (rtx != null);
        wtx.moveTo(w);
        rtx.moveTo(x);
        FMSE.markOutOfOrder(wtx, this.inOrderOldRev);
        FMSE.markOutOfOrder(rtx, this.inOrderNewRev);
        List<Long> first = this.commonChildren(w, x, wtx, rtx, ReverseMap.FALSE);
        List<Long> second = this.commonChildren(x, w, rtx, wtx, ReverseMap.TRUE);
        List<Pair<Long, Long>> s = Util.longestCommonSubsequence(first, second, (pX, pY) -> this.totalMatching.contains((long)pX, (long)pY));
        HashMap<Long, Long> seen = new HashMap<Long, Long>();
        for (Pair<Long, Long> p : s) {
            this.inOrderOldRev.put(p.getFirst(), true);
            this.inOrderNewRev.put(p.getSecond(), true);
            seen.put(p.getFirst(), p.getSecond());
        }
        Iterator<Object> iterator = first.iterator();
        while (iterator.hasNext()) {
            long a = (Long)iterator.next();
            wtx.moveTo(a);
            Long b = this.totalMatching.partner(a);
            if (seen.get(a) != null || !wtx.moveTo(a) || b == null || !rtx.moveTo(b)) continue;
            this.inOrderOldRev.put(a, true);
            this.inOrderNewRev.put(b, true);
            int k = this.findPos(b, wtx, rtx);
            logger.debug("Move in align children: " + k, new Object[0]);
            this.emitMove(a, w, k, wtx, rtx);
        }
    }

    private static void markOutOfOrder(XmlNodeReadOnlyTrx rtx, Map<Long, Boolean> inOrder) {
        ChildAxis axis = new ChildAxis(rtx);
        while (axis.hasNext()) {
            axis.nextLong();
            inOrder.put(axis.asXmlNodeReadTrx().getNodeKey(), false);
        }
    }

    private List<Long> commonChildren(long n, long o, XmlNodeReadOnlyTrx firstRtx, XmlNodeReadOnlyTrx secondRtx, ReverseMap reverse) {
        assert (n >= 0L);
        assert (o >= 0L);
        assert (firstRtx != null);
        assert (secondRtx != null);
        assert (reverse != null);
        LinkedList<Long> retVal = new LinkedList<Long>();
        firstRtx.moveTo(n);
        if (firstRtx.hasFirstChild()) {
            firstRtx.moveToFirstChild();
            do {
                Long partner;
                if ((partner = reverse == ReverseMap.TRUE ? this.totalMatching.reversePartner(firstRtx.getNodeKey()) : this.totalMatching.partner(firstRtx.getNodeKey())) == null) continue;
                secondRtx.moveTo(partner);
                if (secondRtx.getParentKey() != o) continue;
                retVal.add(firstRtx.getNodeKey());
            } while (firstRtx.hasRightSibling() && firstRtx.moveToRightSibling());
        }
        return retVal;
    }

    private void emitMove(long child, long parent, int pos, XmlNodeTrx wtx, XmlNodeReadOnlyTrx rtx) {
        assert (child >= 0L);
        assert (parent >= 0L);
        assert (wtx != null);
        assert (rtx != null);
        boolean moved = wtx.moveTo(child);
        assert (moved);
        if (wtx.getKind() == NodeKind.ATTRIBUTE || wtx.getKind() == NodeKind.NAMESPACE) {
            return;
        }
        assert (pos >= 0);
        moved = wtx.moveTo(parent);
        assert (moved);
        try {
            if (pos == 0) {
                assert (wtx.getKind() == NodeKind.ELEMENT || wtx.getKind() == NodeKind.XML_DOCUMENT);
                if (wtx.getFirstChildKey() == child) {
                    logger.error("Something went wrong: First child and child may never be the same!", new Object[0]);
                } else if (wtx.moveTo(child)) {
                    boolean isTextKind = wtx.getKind() == NodeKind.TEXT;
                    this.checkFromNodeForTextRemoval(wtx, child);
                    wtx.moveTo(parent);
                    if (isTextKind && wtx.getFirstChildKey() != child && wtx.hasFirstChild()) {
                        wtx.moveToFirstChild();
                        if (wtx.getKind() == NodeKind.TEXT) {
                            this.totalMatching.remove(wtx.getNodeKey());
                            wtx.remove();
                        }
                        wtx.moveTo(parent);
                    }
                    if (wtx.getKind() == NodeKind.XML_DOCUMENT) {
                        rtx.moveTo(child);
                        wtx.moveTo(wtx.copySubtreeAsFirstChild(rtx).getNodeKey());
                    } else {
                        wtx.moveTo(wtx.moveSubtreeToFirstChild(child).getNodeKey());
                    }
                }
            } else {
                assert (wtx.hasFirstChild());
                wtx.moveToFirstChild();
                for (int i = 1; i < pos; ++i) {
                    assert (wtx.hasRightSibling());
                    wtx.moveToRightSibling();
                }
                long nodeKey = wtx.getNodeKey();
                this.checkFromNodeForTextRemoval(wtx, child);
                wtx.moveTo(nodeKey);
                if (wtx.getKind() == NodeKind.TEXT && wtx.moveTo(child) && wtx.getKind() == NodeKind.TEXT) {
                    wtx.moveTo(nodeKey);
                    this.totalMatching.remove(wtx.getNodeKey());
                }
                wtx.moveTo(nodeKey);
                if (wtx.moveToRightSibling()) {
                    long rightNodeKey = wtx.getNodeKey();
                    if (wtx.getKind() == NodeKind.TEXT && wtx.moveTo(child) && wtx.getKind() == NodeKind.TEXT) {
                        wtx.moveTo(rightNodeKey);
                        this.totalMatching.remove(wtx.getNodeKey());
                    }
                    wtx.moveToLeftSibling();
                }
                moved = wtx.moveTo(nodeKey);
                assert (moved);
                assert (wtx.getNodeKey() != child);
                wtx.moveTo(wtx.moveSubtreeToRightSibling(child).getNodeKey());
            }
        }
        catch (SirixException e) {
            logger.error(e.getMessage(), e);
        }
    }

    private void checkFromNodeForTextRemoval(XmlNodeTrx wtx, long child) {
        boolean maybeRemoveLeftSibling;
        boolean bl = maybeRemoveLeftSibling = wtx.getLeftSiblingKey() == child;
        if (wtx.moveTo(child)) {
            boolean isText = false;
            if (wtx.hasLeftSibling()) {
                wtx.moveToLeftSibling();
                if (wtx.getKind() == NodeKind.TEXT) {
                    isText = true;
                }
                wtx.moveToRightSibling();
            }
            if (isText && wtx.hasRightSibling()) {
                wtx.moveToRightSibling();
                if (wtx.getKind() == NodeKind.TEXT) {
                    if (maybeRemoveLeftSibling) {
                        boolean moved = wtx.moveToLeftSibling();
                        assert (moved);
                        moved = wtx.moveToLeftSibling();
                        assert (moved);
                    }
                    this.totalMatching.remove(wtx.getNodeKey());
                }
                wtx.moveToLeftSibling();
            }
        }
    }

    private static void emitUpdate(long fromNode, long toNode, XmlNodeTrx wtx, XmlNodeReadOnlyTrx rtx) {
        assert (fromNode >= 0L);
        assert (toNode >= 0L);
        assert (wtx != null);
        assert (rtx != null);
        wtx.moveTo(fromNode);
        rtx.moveTo(toNode);
        try {
            switch (rtx.getKind()) {
                case ELEMENT: 
                case ATTRIBUTE: 
                case NAMESPACE: 
                case PROCESSING_INSTRUCTION: {
                    assert (rtx.getKind() == NodeKind.ELEMENT || rtx.getKind() == NodeKind.ATTRIBUTE || rtx.getKind() == NodeKind.NAMESPACE || rtx.getKind() == NodeKind.PROCESSING_INSTRUCTION);
                    wtx.setName(rtx.getName());
                    if (wtx.getKind() != NodeKind.ATTRIBUTE && wtx.getKind() != NodeKind.PROCESSING_INSTRUCTION) break;
                    wtx.setValue(rtx.getValue());
                    break;
                }
                case TEXT: 
                case COMMENT: {
                    assert (wtx.getKind() == NodeKind.TEXT);
                    wtx.setValue(rtx.getValue());
                    break;
                }
            }
        }
        catch (SirixException e) {
            logger.error(e.getMessage(), e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private long emitInsert(long child, long parent, int pos, XmlNodeTrx wtx, XmlNodeReadOnlyTrx rtx) {
        if (!FMSE.$assertionsDisabled && child < 0L) {
            throw new AssertionError();
        }
        if (!FMSE.$assertionsDisabled && parent < 0L) {
            throw new AssertionError();
        }
        if (!FMSE.$assertionsDisabled && wtx == null) {
            throw new AssertionError();
        }
        if (!FMSE.$assertionsDisabled && rtx == null) {
            throw new AssertionError();
        }
        if (this.alreadyInserted.get(child) != null) {
            return child;
        }
        wtx.moveTo(parent);
        rtx.moveTo(child);
        try {
            switch (1.$SwitchMap$io$sirix$node$NodeKind[rtx.getKind().ordinal()]) {
                case 2: {
                    try {
                        wtx.insertAttribute(rtx.getName(), rtx.getValue());
                    }
                    catch (SirixUsageException e) {
                        this.totalMatching.remove(wtx.getNodeKey());
                        if (rtx.getValue().isEmpty()) ** GOTO lbl28
                        wtx.setValue(rtx.getValue());
                    }
lbl28:
                    // 3 sources

                    this.process(wtx.getNodeKey(), rtx.getNodeKey());
                    break;
                }
                case 3: {
                    try {
                        qName = rtx.getName();
                        wtx.insertNamespace(new QNm(qName.getNamespaceURI(), qName.getPrefix(), qName.getLocalName()));
                    }
                    catch (SirixUsageException e) {
                        this.totalMatching.remove(wtx.getNodeKey());
                    }
                    this.process(wtx.getNodeKey(), rtx.getNodeKey());
                    break;
                }
                default: {
                    oldKey = 0L;
                    if (pos == 0) {
                        switch (1.$SwitchMap$io$sirix$node$NodeKind[rtx.getKind().ordinal()]) {
                            case 1: {
                                oldKey = wtx.copySubtreeAsFirstChild(rtx).getNodeKey();
                                break;
                            }
                            case 5: {
                                if (wtx.hasFirstChild()) {
                                    wtx.moveToFirstChild();
                                    if (wtx.getKind() == NodeKind.TEXT) {
                                        this.totalMatching.remove(wtx.getNodeKey());
                                        wtx.remove();
                                    }
                                    wtx.moveTo(parent);
                                }
                                oldKey = wtx.insertTextAsFirstChild(rtx.getValue()).getNodeKey();
                                break;
                            }
                        }
                    } else {
                        if (!FMSE.$assertionsDisabled && !wtx.hasFirstChild()) {
                            throw new AssertionError();
                        }
                        wtx.moveToFirstChild();
                        for (i = 0; i < pos - 1; ++i) {
                            if (!FMSE.$assertionsDisabled && !wtx.hasRightSibling()) {
                                throw new AssertionError();
                            }
                            wtx.moveToRightSibling();
                        }
                        this.removeRightSiblingTextNode(wtx);
                        switch (1.$SwitchMap$io$sirix$node$NodeKind[rtx.getKind().ordinal()]) {
                            case 1: {
                                v0 = wtx.copySubtreeAsRightSibling(rtx).getNodeKey();
                                break;
                            }
                            case 5: {
                                v0 = wtx.insertTextAsRightSibling(rtx.getValue()).getNodeKey();
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Child should be already inserted!");
                            }
                        }
                        oldKey = v0;
                    }
                    wtx.moveTo(oldKey);
                    rtx.moveTo(child);
                    oldAxis = new DescendantAxis(wtx, IncludeSelf.YES);
                    newAxis = new DescendantAxis(rtx, IncludeSelf.YES);
                    while (oldAxis.hasNext() && newAxis.hasNext()) {
                        oldAxis.nextLong();
                        newAxis.nextLong();
                        oldRtx = oldAxis.asXmlNodeReadTrx();
                        newRtx = newAxis.asXmlNodeReadTrx();
                        this.process(oldRtx.getNodeKey(), newRtx.getNodeKey());
                        newNodeKey = newRtx.getNodeKey();
                        oldNodeKey = oldRtx.getNodeKey();
                        if (newRtx.getKind() == NodeKind.ELEMENT) {
                            if (!FMSE.$assertionsDisabled && newRtx.getKind() != oldRtx.getKind()) {
                                throw new AssertionError();
                            }
                            if (newRtx.getAttributeCount() > 0) {
                                attCount = newRtx.getAttributeCount();
                                for (i = 0; i < attCount; ++i) {
                                    rtx.moveToAttribute(i);
                                    oldAttCount = oldRtx.getAttributeCount();
                                    for (j = 0; j < oldAttCount; ++j) {
                                        wtx.moveToAttribute(j);
                                        if (wtx.getName().equals((Object)rtx.getName())) {
                                            this.process(oldAxis.asXmlNodeReadTrx().getNodeKey(), newAxis.asXmlNodeReadTrx().getNodeKey());
                                            break;
                                        }
                                        oldAxis.asXmlNodeReadTrx().moveTo(oldNodeKey);
                                    }
                                    newAxis.asXmlNodeReadTrx().moveTo(newNodeKey);
                                }
                            }
                            if (newRtx.getNamespaceCount() > 0) {
                                nspCount = newRtx.getNamespaceCount();
                                for (i = 0; i < nspCount; ++i) {
                                    rtx.moveToNamespace(i);
                                    oldNspCount = oldRtx.getNamespaceCount();
                                    for (j = 0; j < oldNspCount; ++j) {
                                        wtx.moveToNamespace(j);
                                        if (wtx.getName().getNamespaceURI().equals(rtx.getName().getNamespaceURI()) && wtx.getName().getPrefix().equals(wtx.getName().getPrefix())) {
                                            this.process(wtx.getNodeKey(), rtx.getNodeKey());
                                            break;
                                        }
                                        oldAxis.asXmlNodeReadTrx().moveTo(oldNodeKey);
                                    }
                                    newAxis.asXmlNodeReadTrx().moveTo(newNodeKey);
                                }
                            }
                        }
                        newAxis.asXmlNodeReadTrx().moveTo(newNodeKey);
                    }
                    break;
                }
            }
        }
        catch (SirixException e) {
            FMSE.logger.error(e.getMessage(), new Object[]{e});
        }
        return wtx.getNodeKey();
    }

    private void removeRightSiblingTextNode(XmlNodeTrx wtx) throws SirixException {
        assert (wtx != null);
        if (wtx.hasRightSibling()) {
            long nodeKey = wtx.getNodeKey();
            wtx.moveToRightSibling();
            if (wtx.getKind() == NodeKind.TEXT) {
                this.totalMatching.remove(wtx.getNodeKey());
                wtx.remove();
            }
            wtx.moveTo(nodeKey);
        }
    }

    private void process(long oldKey, long newKey) {
        Long reversePartner;
        this.alreadyInserted.put(newKey, true);
        Long partner = this.totalMatching.partner(oldKey);
        if (partner != null) {
            this.totalMatching.remove(oldKey);
        }
        if ((reversePartner = this.totalMatching.reversePartner(newKey)) != null) {
            this.totalMatching.remove(reversePartner);
        }
        assert (!this.totalMatching.contains(oldKey, newKey));
        this.totalMatching.add(oldKey, newKey);
        this.inOrderOldRev.put(oldKey, true);
        this.inOrderNewRev.put(newKey, true);
    }

    private int findPos(long x, XmlNodeTrx wtx, XmlNodeReadOnlyTrx rtx) {
        long v;
        assert (x > 0L);
        assert (wtx != null);
        assert (rtx != null);
        rtx.moveTo(x);
        if (rtx.getKind() == NodeKind.ATTRIBUTE || rtx.getKind() == NodeKind.NAMESPACE) {
            return 0;
        }
        long nodeKey = rtx.getNodeKey();
        rtx.moveToParent();
        if (rtx.hasFirstChild()) {
            rtx.moveToFirstChild();
            v = rtx.getNodeKey();
            if (this.inOrderNewRev.get(v) != null && this.inOrderNewRev.get(v).booleanValue() && v == x) {
                return 0;
            }
        }
        rtx.moveTo(nodeKey);
        rtx.moveToLeftSibling();
        v = rtx.getNodeKey();
        while (rtx.hasLeftSibling() && (this.inOrderNewRev.get(v) == null || this.inOrderNewRev.get(v) != null && !this.inOrderNewRev.get(v).booleanValue())) {
            rtx.moveToLeftSibling();
            v = rtx.getNodeKey();
        }
        if (this.inOrderNewRev.get(v) == null) {
            return 0;
        }
        Long u = this.totalMatching.reversePartner(v);
        int i = -1;
        if (u != null) {
            boolean moved = wtx.moveTo(u);
            assert (moved);
            long toNodeKey = u;
            wtx.moveToParent();
            wtx.moveToFirstChild();
            do {
                u = wtx.getNodeKey();
                ++i;
            } while (u != toNodeKey && wtx.hasRightSibling() && wtx.moveToRightSibling());
        }
        return i + 1;
    }

    private Matching fastMatch(XmlNodeTrx wtx, XmlNodeReadOnlyTrx rtx) {
        assert (wtx != null);
        assert (rtx != null);
        FMSENodeComparisonUtils nodeComparisonUtils = new FMSENodeComparisonUtils(this.oldStartKey, this.newStartKey, wtx, rtx);
        FMSE.getLabels(wtx, this.labelOldRevVisitor);
        FMSE.getLabels(rtx, this.labelNewRevVisitor);
        Matching matching = new Matching(wtx, rtx);
        matching.reset();
        FMSE.match(this.labelOldRevVisitor.getLeafLabels(), this.labelNewRevVisitor.getLeafLabels(), matching, new LeafNodeComparator(this.idName, this.wtx, this.rtx, this.oldPathSummary, this.newPathSummary, nodeComparisonUtils));
        Map<NodeKind, List<Long>> oldLabels = this.labelOldRevVisitor.getLabels();
        Map<NodeKind, List<Long>> newLabels = this.labelNewRevVisitor.getLabels();
        oldLabels.remove(NodeKind.XML_DOCUMENT);
        newLabels.remove(NodeKind.XML_DOCUMENT);
        wtx.moveTo(this.oldStartKey);
        rtx.moveTo(this.newStartKey);
        wtx.moveToParent();
        rtx.moveToParent();
        matching.add(wtx.getNodeKey(), rtx.getNodeKey());
        NodeComparator<Long> innerNodeComparator = this.nodeComparisonFactory.createInnerNodeEqualityChecker(this.idName, matching, wtx, rtx, new FMSENodeComparisonUtils(this.oldStartKey, this.newStartKey, wtx, rtx), this.descendantsOldRev, this.descendantsNewRev);
        FMSE.match(oldLabels, newLabels, matching, innerNodeComparator);
        return matching;
    }

    private static void match(Map<NodeKind, List<Long>> oldLabels, Map<NodeKind, List<Long>> newLabels, Matching matching, NodeComparator<Long> cmp) {
        Set<NodeKind> labels = oldLabels.keySet();
        labels.retainAll(newLabels.keySet());
        for (NodeKind label : labels) {
            List<Long> first = oldLabels.get(label);
            List<Long> second = newLabels.get(label);
            List<Pair<Long, Long>> common = Util.longestCommonSubsequence(first, second, cmp);
            HashMap<Long, Boolean> seen = new HashMap<Long, Boolean>();
            for (Pair<Long, Long> p : common) {
                matching.add(p.getFirst(), p.getSecond());
                seen.put(p.getFirst(), true);
                seen.put(p.getSecond(), true);
            }
            FMSE.removeCommonNodes(first, seen);
            FMSE.removeCommonNodes(second, seen);
            Iterator<Long> firstIterator = first.iterator();
            block2: while (firstIterator.hasNext()) {
                Long firstItem = firstIterator.next();
                boolean firstIter = true;
                Iterator<Long> secondIterator = second.iterator();
                while (secondIterator.hasNext()) {
                    Long secondItem = secondIterator.next();
                    if (!cmp.isEqual(firstItem, secondItem)) continue;
                    matching.add(firstItem, secondItem);
                    if (firstIter) {
                        firstIter = false;
                        firstIterator.remove();
                    }
                    secondIterator.remove();
                    continue block2;
                }
            }
        }
    }

    private static void removeCommonNodes(List<Long> list, Map<Long, Boolean> seen) {
        assert (list != null);
        assert (seen != null);
        list.removeIf(seen::containsKey);
    }

    private static void init(XmlNodeReadOnlyTrx rtx, XmlNodeVisitor visitor) {
        assert (visitor != null);
        long nodeKey = rtx.getNodeKey();
        PostOrderAxis axis = new PostOrderAxis(rtx);
        while (axis.hasNext()) {
            axis.nextLong();
            if (axis.asXmlNodeReadTrx().getNodeKey() == nodeKey) break;
            axis.asXmlNodeReadTrx().acceptVisitor(visitor);
        }
        rtx.acceptVisitor(visitor);
    }

    private static void getLabels(XmlNodeReadOnlyTrx rtx, LabelFMSEVisitor visitor) {
        assert (rtx != null);
        assert (visitor != null);
        long nodeKey = rtx.getNodeKey();
        PostOrderAxis axis = new PostOrderAxis(rtx);
        while (axis.hasNext()) {
            axis.nextLong();
            if (axis.asXmlNodeReadTrx().getNodeKey() == nodeKey) break;
            axis.asXmlNodeReadTrx().acceptVisitor(visitor);
        }
        rtx.acceptVisitor(visitor);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void close() {
        this.wtx.commit();
        this.oldPathSummary.close();
        this.newPathSummary.close();
    }

    static enum ReverseMap {
        TRUE,
        FALSE;

    }
}

