/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.diff.algorithm.fmse;

import io.brackit.query.atomic.QNm;
import io.sirix.access.Utils;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.diff.algorithm.fmse.Levenshtein;
import io.sirix.diff.algorithm.fmse.Util;
import java.util.Objects;

class FMSENodeComparisonUtils {
    private static final int MAX_LENGTH = 50;
    private final long oldStartKey;
    private final long newStartKey;
    private final XmlNodeReadOnlyTrx oldRtx;
    private final XmlNodeReadOnlyTrx newRtx;

    FMSENodeComparisonUtils(long oldStartKey, long newStartKey, XmlNodeReadOnlyTrx oldRtx, XmlNodeReadOnlyTrx newRtx) {
        this.oldStartKey = oldStartKey;
        this.newStartKey = newStartKey;
        this.oldRtx = oldRtx;
        this.newRtx = newRtx;
    }

    boolean nodeValuesEqual(long x, long y, XmlNodeReadOnlyTrx oldRtx, XmlNodeReadOnlyTrx newRtx) {
        assert (x >= 0L);
        assert (y >= 0L);
        assert (oldRtx != null);
        assert (newRtx != null);
        String a = this.getNodeValue(x, oldRtx);
        String b = this.getNodeValue(y, newRtx);
        return Objects.equals(a, b);
    }

    float calculateRatio(String oldValue, String newValue) {
        assert (oldValue != null);
        assert (newValue != null);
        float ratio = oldValue.length() > 50 || newValue.length() > 50 ? Util.quickRatio(oldValue, newValue) : Levenshtein.getSimilarity(oldValue, newValue);
        return ratio;
    }

    boolean checkAncestors(long oldKey, long newKey) {
        assert (oldKey >= 0L);
        assert (newKey >= 0L);
        this.oldRtx.moveTo(oldKey);
        this.newRtx.moveTo(newKey);
        boolean retVal = true;
        if (this.oldRtx.hasParent() && this.newRtx.hasParent()) {
            do {
                this.oldRtx.moveToParent();
                this.newRtx.moveToParent();
                if (!this.oldRtx.hasAttributes() || !this.newRtx.hasAttributes() || this.checkAttributes()) continue;
                return false;
            } while (this.oldRtx.getNodeKey() != this.oldStartKey && this.newRtx.getNodeKey() != this.newStartKey && this.oldRtx.hasParent() && this.newRtx.hasParent() && this.calculateRatio(this.getNodeValue(this.oldRtx.getNodeKey(), this.oldRtx), this.getNodeValue(this.newRtx.getNodeKey(), this.newRtx)) >= 0.7f);
            retVal = !(this.oldRtx.hasParent() && this.oldRtx.getNodeKey() != this.oldStartKey || this.newRtx.hasParent() && this.newRtx.getNodeKey() != this.newStartKey);
        } else {
            retVal = false;
        }
        this.oldRtx.moveTo(oldKey);
        this.newRtx.moveTo(newKey);
        return retVal;
    }

    boolean checkAttributes() {
        long newNodeKey = this.newRtx.getNodeKey();
        long oldNodeKey = this.oldRtx.getNodeKey();
        int attCount = this.oldRtx.getAttributeCount();
        for (int i = 0; i < attCount; ++i) {
            this.oldRtx.moveToAttribute(i);
            QNm name = this.oldRtx.getName();
            if (this.newRtx.moveToAttributeByName(name) && (this.calculateRatio(this.getNodeValue(this.oldRtx.getNodeKey(), this.oldRtx), this.getNodeValue(this.newRtx.getNodeKey(), this.newRtx)) < 0.7f || this.calculateRatio(this.oldRtx.getValue(), this.newRtx.getValue()) < 0.7f)) {
                this.newRtx.moveTo(newNodeKey);
                this.oldRtx.moveTo(oldNodeKey);
                return false;
            }
            this.newRtx.moveTo(newNodeKey);
            this.oldRtx.moveTo(oldNodeKey);
        }
        this.newRtx.moveTo(newNodeKey);
        this.oldRtx.moveTo(oldNodeKey);
        return true;
    }

    boolean checkIfAncestorIdsMatch(long oldKey, long newKey, QNm id) {
        assert (oldKey >= 0L);
        assert (newKey >= 0L);
        this.oldRtx.moveTo(oldKey);
        this.newRtx.moveTo(newKey);
        boolean retVal = false;
        if (this.oldRtx.hasParent() && this.newRtx.hasParent()) {
            do {
                this.oldRtx.moveToParent();
                this.newRtx.moveToParent();
                if (this.oldRtx.isElement() && this.newRtx.isElement() && this.oldRtx.moveToAttributeByName(id) && this.newRtx.moveToAttributeByName(id)) {
                    if (!this.newRtx.getValue().equals(this.oldRtx.getValue())) continue;
                    retVal = true;
                    continue;
                }
                retVal = false;
                break;
            } while (this.oldRtx.getNodeKey() != this.oldStartKey && this.newRtx.getNodeKey() != this.newStartKey && this.oldRtx.hasParent() && this.newRtx.hasParent());
        }
        this.oldRtx.moveTo(oldKey);
        this.newRtx.moveTo(newKey);
        return retVal;
    }

    String getNodeValue(long nodeKey, XmlNodeReadOnlyTrx rtx) {
        assert (nodeKey >= 0L);
        assert (rtx != null);
        rtx.moveTo(nodeKey);
        StringBuilder retVal = new StringBuilder();
        switch (rtx.getKind()) {
            case ELEMENT: 
            case NAMESPACE: 
            case ATTRIBUTE: {
                retVal.append(Utils.buildName(rtx.getName()));
                break;
            }
            case TEXT: 
            case COMMENT: {
                retVal.append(rtx.getValue());
                break;
            }
            case PROCESSING_INSTRUCTION: {
                retVal.append(rtx.getName().getLocalName()).append(" ").append(rtx.getValue());
                break;
            }
        }
        return retVal.toString();
    }
}

