/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.diff.algorithm.fmse;

import io.brackit.query.atomic.QNm;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.diff.algorithm.fmse.FMSENodeComparisonUtils;
import io.sirix.diff.algorithm.fmse.Matching;
import io.sirix.diff.algorithm.fmse.NodeComparator;
import java.util.Map;

final class InnerNodeComparator
implements NodeComparator<Long> {
    private static final double FMESTHRESHOLD = 0.5;
    private final Matching matching;
    private final XmlNodeReadOnlyTrx oldRtx;
    private final XmlNodeReadOnlyTrx newRtx;
    private final QNm idName;
    private final FMSENodeComparisonUtils nodeComparisonUtils;
    private final Map<Long, Long> descendantsOldRev;
    private final Map<Long, Long> descendantsNewRev;

    public InnerNodeComparator(QNm idName, Matching matching, XmlNodeReadOnlyTrx oldRtx, XmlNodeReadOnlyTrx newRtx, FMSENodeComparisonUtils nodeComparisonUtils, Map<Long, Long> descendantsOldRev, Map<Long, Long> descendantsNewRev) {
        assert (matching != null);
        assert (oldRtx != null);
        assert (newRtx != null);
        assert (nodeComparisonUtils != null);
        assert (descendantsOldRev != null);
        assert (descendantsNewRev != null);
        this.idName = idName;
        this.matching = matching;
        this.oldRtx = oldRtx;
        this.newRtx = newRtx;
        this.nodeComparisonUtils = nodeComparisonUtils;
        this.descendantsOldRev = descendantsOldRev;
        this.descendantsNewRev = descendantsNewRev;
    }

    @Override
    public boolean isEqual(Long firstNode, Long secondNode) {
        assert (firstNode != null);
        assert (secondNode != null);
        this.oldRtx.moveTo(firstNode);
        this.newRtx.moveTo(secondNode);
        assert (this.oldRtx.getKind() == this.newRtx.getKind());
        boolean retVal = false;
        if (this.idName != null && this.oldRtx.isElement() && this.newRtx.isElement() && this.oldRtx.moveToAttributeByName(this.idName) && this.newRtx.moveToAttributeByName(this.idName)) {
            retVal = this.newRtx.getValue().equals(this.oldRtx.getValue());
        } else if ((this.oldRtx.hasFirstChild() || this.oldRtx.hasAttributes() || this.oldRtx.hasNamespaces()) && (this.newRtx.hasFirstChild() || this.newRtx.hasAttributes() || this.newRtx.hasNamespaces())) {
            long common = this.matching.containedDescendants(firstNode, secondNode);
            long maxFamilySize = Math.max(this.descendantsOldRev.get(firstNode), this.descendantsNewRev.get(secondNode));
            retVal = common == 0L && maxFamilySize == 1L ? this.oldRtx.getName().equals((Object)this.newRtx.getName()) : (double)common / (double)maxFamilySize >= 0.5;
        } else {
            QNm oldName = this.oldRtx.getName();
            QNm newName = this.newRtx.getName();
            if (oldName.getNamespaceURI().equals(newName.getNamespaceURI()) && (double)this.nodeComparisonUtils.calculateRatio(oldName.getLocalName(), newName.getLocalName()) > 0.7) {
                retVal = this.nodeComparisonUtils.checkAncestors(this.oldRtx.getNodeKey(), this.newRtx.getNodeKey());
            }
        }
        return retVal;
    }
}

