/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.diff.algorithm.fmse;

import io.sirix.access.trx.node.xml.AbstractXmlNodeVisitor;
import io.sirix.api.visitor.VisitResultType;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.node.NodeKind;
import io.sirix.node.immutable.xml.ImmutableElement;
import io.sirix.node.immutable.xml.ImmutableText;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class LabelFMSEVisitor
extends AbstractXmlNodeVisitor {
    private final XmlNodeReadOnlyTrx rtx;
    private final Map<NodeKind, List<Long>> labels;
    private final Map<NodeKind, List<Long>> leafLabels;

    public LabelFMSEVisitor(XmlNodeReadOnlyTrx readTrx) {
        this.rtx = Objects.requireNonNull(readTrx);
        this.labels = new HashMap<NodeKind, List<Long>>();
        this.leafLabels = new HashMap<NodeKind, List<Long>>();
    }

    @Override
    public VisitResultType visit(ImmutableElement node) {
        int i;
        long nodeKey = node.getNodeKey();
        this.rtx.moveTo(nodeKey);
        int nspCount = this.rtx.getNamespaceCount();
        for (i = 0; i < nspCount; ++i) {
            this.rtx.moveToNamespace(i);
            this.addLeafLabel();
            this.rtx.moveTo(nodeKey);
        }
        int attCount = this.rtx.getAttributeCount();
        for (i = 0; i < attCount; ++i) {
            this.rtx.moveToAttribute(i);
            this.addLeafLabel();
            this.rtx.moveTo(nodeKey);
        }
        if (!this.labels.containsKey(node.getKind())) {
            this.labels.put(node.getKind(), new ArrayList());
        }
        this.labels.get(node.getKind()).add(node.getNodeKey());
        return VisitResultType.CONTINUE;
    }

    @Override
    public VisitResultType visit(ImmutableText node) {
        this.rtx.moveTo(node.getNodeKey());
        this.addLeafLabel();
        return VisitResultType.CONTINUE;
    }

    private void addLeafLabel() {
        NodeKind nodeKind = this.rtx.getKind();
        if (!this.leafLabels.containsKey(nodeKind)) {
            this.leafLabels.put(nodeKind, new ArrayList());
        }
        this.leafLabels.get(nodeKind).add(this.rtx.getNodeKey());
    }

    public Map<NodeKind, List<Long>> getLabels() {
        return this.labels;
    }

    public Map<NodeKind, List<Long>> getLeafLabels() {
        return this.leafLabels;
    }
}

