/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.diff.service;

import io.brackit.query.atomic.QNm;
import io.sirix.access.DatabaseConfiguration;
import io.sirix.access.Databases;
import io.sirix.access.ResourceConfiguration;
import io.sirix.api.Database;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.api.xml.XmlNodeTrx;
import io.sirix.api.xml.XmlResourceSession;
import io.sirix.diff.algorithm.fmse.DefaultNodeComparisonFactory;
import io.sirix.diff.algorithm.fmse.FMSE;
import io.sirix.exception.SirixException;
import io.sirix.exception.SirixIOException;
import io.sirix.service.InsertPosition;
import io.sirix.service.xml.shredder.XmlShredder;
import io.sirix.utils.LogWrapper;
import io.sirix.utils.SirixFiles;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import javax.xml.stream.XMLEventReader;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.LoggerFactory;

public final class FMSEImport {
    private static final LogWrapper LOGWRAPPER = new LogWrapper(LoggerFactory.getLogger(FMSEImport.class));

    public void shredder(Path resNewRev, @NonNull Path newRev) {
        assert (resNewRev != null);
        assert (newRev != null);
        DatabaseConfiguration conf = new DatabaseConfiguration(newRev);
        Databases.removeDatabase(newRev);
        Databases.createXmlDatabase(conf);
        try (Database<XmlResourceSession> db = Databases.openXmlDatabase(newRev);){
            db.createResource(new ResourceConfiguration.Builder("shredded").buildPathSummary(true).useDeweyIDs(true).build());
            try (XmlResourceSession resMgr = db.beginResourceSession("shredded");
                 XmlNodeTrx wtx = (XmlNodeTrx)resMgr.beginNodeTrx();
                 FileInputStream fis = new FileInputStream(resNewRev.toFile());){
                XMLEventReader fileReader = XmlShredder.createFileReader(fis);
                XmlShredder shredder = new XmlShredder.Builder(wtx, fileReader, InsertPosition.AS_FIRST_CHILD).commitAfterwards().build();
                shredder.call();
            }
            catch (IOException e) {
                throw new SirixIOException(e.getCause());
            }
        }
    }

    public void xmlDataImport(Path resOldRev, @NonNull Path resNewRev, QNm idName) {
        this.importData(resOldRev, resNewRev, idName);
    }

    private void xmlDataImport(Path resOldRev, @NonNull Path resNewRev) {
        this.importData(resOldRev, resNewRev, null);
    }

    private void importData(Path resOldRev, Path resNewRev, QNm idName) {
        try {
            Path newRevTarget = Files.createTempDirectory(resNewRev.getFileName().toString(), new FileAttribute[0]);
            if (Files.exists(newRevTarget, new LinkOption[0])) {
                SirixFiles.recursiveRemove(newRevTarget);
            }
            this.shredder(Objects.requireNonNull(resNewRev), newRevTarget);
            try (Database<XmlResourceSession> databaseOld = Databases.openXmlDatabase(resOldRev);
                 XmlResourceSession resMgrOld = databaseOld.beginResourceSession("shredded");
                 XmlNodeTrx wtx = (XmlNodeTrx)resMgrOld.beginNodeTrx();
                 Database<XmlResourceSession> databaseNew = Databases.openXmlDatabase(newRevTarget);
                 XmlResourceSession resourceNew = databaseNew.beginResourceSession("shredded");
                 XmlNodeReadOnlyTrx rtx = (XmlNodeReadOnlyTrx)resourceNew.beginNodeReadOnlyTrx();
                 FMSE fmes = idName == null ? FMSE.createInstance(new DefaultNodeComparisonFactory()) : FMSE.createWithIdentifier(idName, new DefaultNodeComparisonFactory());){
                fmes.diff(wtx, rtx);
            }
        }
        catch (SirixException | IOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    public static void main(String[] args) {
        if (args.length < 2 || args.length > 4) {
            throw new IllegalArgumentException("Usage: FSME oldResource newXMLDocument [startNodeKeyOld] [startNodeKeyNew]");
        }
        Path resOldRev = Paths.get(args[0], new String[0]);
        Path resNewRev = Paths.get(args[1], new String[0]);
        if (args.length == 3) {
            new FMSEImport().xmlDataImport(resOldRev, resNewRev, new QNm(args[2]));
        } else {
            new FMSEImport().xmlDataImport(resOldRev, resNewRev);
        }
    }
}

