/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index;

import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Una;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.Type;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.node.parser.FragmentHelper;
import io.brackit.query.util.path.Path;
import io.brackit.query.util.path.PathParser;
import io.brackit.query.util.serialize.SubtreePrinter;
import io.sirix.index.IndexType;
import io.sirix.index.Materializable;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class IndexDef
implements Materializable {
    private static final QNm DB_TYPE_ATTRIBUTE = new QNm("dbType");
    private static final QNm EXCLUDING_TAG = new QNm("excluding");
    private static final QNm INCLUDING_TAG = new QNm("including");
    private static final QNm PATH_TAG = new QNm("path");
    private static final QNm UNIQUE_ATTRIBUTE = new QNm("unique");
    private static final QNm CONTENT_TYPE_ATTRIBUTE = new QNm("keyType");
    private static final QNm TYPE_ATTRIBUTE = new QNm("type");
    private static final QNm ID_ATTRIBUTE = new QNm("id");
    public static final QNm INDEX_TAG = new QNm("index");
    private DbType dbType;
    private IndexType type;
    private boolean unique = false;
    private Type contentType;
    private int id;
    private final Set<Path<QNm>> paths = new HashSet<Path<QNm>>();
    private final Set<QNm> excluded = new HashSet<QNm>();
    private final Set<QNm> included = new HashSet<QNm>();

    public IndexDef(DbType dbType) {
        this.dbType = dbType;
    }

    IndexDef(Set<QNm> included, Set<QNm> excluded, int indexDefNo, DbType dbType) {
        this.type = IndexType.NAME;
        this.included.addAll(included);
        this.excluded.addAll(excluded);
        this.id = indexDefNo;
        this.dbType = dbType;
    }

    IndexDef(Set<Path<QNm>> paths, int indexDefNo, DbType dbType) {
        this.type = IndexType.PATH;
        this.paths.addAll(paths);
        this.id = indexDefNo;
        this.dbType = dbType;
    }

    IndexDef(Type contentType, Set<Path<QNm>> paths, boolean unique, int indexDefNo, DbType dbType) {
        this.type = IndexType.CAS;
        this.contentType = Objects.requireNonNull(contentType);
        this.paths.addAll(paths);
        this.unique = unique;
        this.id = indexDefNo;
        this.dbType = dbType;
    }

    @Override
    public Node<?> materialize() throws DocumentException {
        StringBuilder buf;
        FragmentHelper tmp = new FragmentHelper();
        tmp.openElement(INDEX_TAG);
        tmp.attribute(TYPE_ATTRIBUTE, (Atomic)new Una(this.type.toString()));
        tmp.attribute(DB_TYPE_ATTRIBUTE, (Atomic)new Una(this.dbType.toString()));
        tmp.attribute(ID_ATTRIBUTE, (Atomic)new Una(Integer.toString(this.id)));
        if (this.contentType != null) {
            tmp.attribute(CONTENT_TYPE_ATTRIBUTE, (Atomic)new Una(this.contentType.toString()));
        }
        if (this.unique) {
            tmp.attribute(UNIQUE_ATTRIBUTE, (Atomic)new Una(Boolean.toString(this.unique)));
        }
        if (!this.paths.isEmpty()) {
            for (Path<QNm> path : this.paths) {
                tmp.openElement(PATH_TAG);
                tmp.content(path.toString());
                tmp.closeElement();
            }
        }
        if (!this.excluded.isEmpty()) {
            tmp.openElement(EXCLUDING_TAG);
            buf = new StringBuilder();
            for (QNm s : this.excluded) {
                buf.append(s).append(",");
            }
            buf.deleteCharAt(buf.length() - 1);
            tmp.content(buf.toString());
            tmp.closeElement();
        }
        if (!this.included.isEmpty()) {
            tmp.openElement(INCLUDING_TAG);
            buf = new StringBuilder();
            for (QNm incl : this.included) {
                buf.append(incl).append(",");
            }
            buf.deleteCharAt(buf.length() - 1);
            tmp.content(buf.toString());
            tmp.closeElement();
        }
        tmp.closeElement();
        return tmp.getRoot();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void init(Node<?> root) throws DocumentException {
        name = root.getName();
        if (!name.equals((Object)IndexDef.INDEX_TAG)) {
            throw new DocumentException("Expected tag '%s' but found '%s'", new Object[]{IndexDef.INDEX_TAG, name});
        }
        attribute = root.getAttribute(IndexDef.ID_ATTRIBUTE);
        if (attribute != null) {
            this.id = Integer.parseInt(attribute.getValue().stringValue());
        }
        if ((attribute = root.getAttribute(IndexDef.TYPE_ATTRIBUTE)) != null) {
            this.type = IndexType.valueOf(attribute.getValue().stringValue());
        }
        if ((attribute = root.getAttribute(IndexDef.CONTENT_TYPE_ATTRIBUTE)) != null) {
            this.contentType = IndexDef.resolveType(attribute.getValue().stringValue());
        }
        if ((attribute = root.getAttribute(IndexDef.UNIQUE_ATTRIBUTE)) != null) {
            this.unique = Boolean.parseBoolean(attribute.getValue().stringValue());
        }
        if ((attribute = root.getAttribute(IndexDef.DB_TYPE_ATTRIBUTE)) != null) {
            this.dbType = DbType.ofString(attribute.getValue().stringValue()).orElseThrow((Supplier<DocumentException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$init$0(), ()Lio/brackit/query/jdm/DocumentException;)());
        }
        children = root.getChildren();
lbl16:
        // 3 sources

        try {
            while ((child = (Node)children.next()) != null) {
                block17: {
                    childName = child.getName();
                    value = child.getValue().stringValue();
                    if (childName.equals((Object)IndexDef.PATH_TAG)) {
                        this.paths.add((Path<QNm>)Path.parse((String)value, (PathParser.Type)(this.dbType == DbType.JSON ? PathParser.Type.JSON : PathParser.Type.XML)));
                        continue;
                    }
                    if (!childName.equals((Object)IndexDef.INCLUDING_TAG)) break block17;
                    for (String s : value.split(",")) {
                        if (s.length() <= 0) continue;
                        this.included.add(new QNm(s));
                    }
                    ** GOTO lbl16
                }
                if (!childName.equals((Object)IndexDef.EXCLUDING_TAG)) continue;
                for (String s : value.split(",")) {
                    if (s.length() <= 0) continue;
                    this.excluded.add(new QNm(s));
                }
                ** GOTO lbl16
            }
        }
        finally {
            if (children != null) {
                children.close();
            }
        }
    }

    private static Type resolveType(String s) throws DocumentException {
        QNm name = new QNm("http://www.w3.org/2001/XMLSchema", "xs", s.substring("xs".length() + 1));
        for (Type type : Type.builtInTypes) {
            if (!type.getName().getLocalName().equals(name.getLocalName())) continue;
            return type;
        }
        throw new DocumentException("Unknown content type type: '%s'", new Object[]{name});
    }

    public boolean isNameIndex() {
        return this.type == IndexType.NAME;
    }

    public boolean isCasIndex() {
        return this.type == IndexType.CAS;
    }

    public boolean isPathIndex() {
        return this.type == IndexType.PATH;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public int getID() {
        return this.id;
    }

    public IndexType getType() {
        return this.type;
    }

    public Set<Path<QNm>> getPaths() {
        return Collections.unmodifiableSet(this.paths);
    }

    public Set<QNm> getIncluded() {
        return Collections.unmodifiableSet(this.included);
    }

    public Set<QNm> getExcluded() {
        return Collections.unmodifiableSet(this.excluded);
    }

    public String toString() {
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            SubtreePrinter.print(this.materialize(), (PrintStream)new PrintStream(buf));
            return buf.toString();
        }
        catch (DocumentException e) {
            return e.getMessage();
        }
    }

    public Type getContentType() {
        return this.contentType;
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IndexDef)) {
            return false;
        }
        IndexDef other = (IndexDef)obj;
        return this.id == other.id && this.type == other.type;
    }

    private static /* synthetic */ DocumentException lambda$init$0() {
        return new DocumentException("Invalid db type", new Object[0]);
    }

    public static enum DbType {
        XML,
        JSON;


        public static Optional<DbType> ofString(String type) {
            return Arrays.stream(DbType.values()).filter(env -> env.name().equalsIgnoreCase(type)).findFirst();
        }
    }
}

