/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index;

import com.google.common.collect.ImmutableSet;
import io.brackit.query.atomic.QNm;
import io.brackit.query.jdm.Type;
import io.brackit.query.util.path.Path;
import io.sirix.index.IndexDef;
import java.util.Set;

public final class IndexDefs {
    private IndexDefs() {
        throw new AssertionError((Object)"May never be instantiated!");
    }

    public static IndexDef createCASIdxDef(boolean unique, Type optType, Set<Path<QNm>> paths, int indexDefNo, IndexDef.DbType dbType) {
        Type type = optType == null ? Type.STR : optType;
        return new IndexDef(type, paths, unique, indexDefNo, dbType);
    }

    public static IndexDef createPathIdxDef(Set<Path<QNm>> paths, int indexDefNo, IndexDef.DbType dbType) {
        return new IndexDef(paths, indexDefNo, dbType);
    }

    public static IndexDef createNameIdxDef(int indexDefNo, IndexDef.DbType dbType) {
        return switch (dbType) {
            default -> throw new MatchException(null, null);
            case IndexDef.DbType.JSON -> new IndexDef((Set<QNm>)ImmutableSet.of(), (Set<QNm>)ImmutableSet.of(), 1 + indexDefNo, dbType);
            case IndexDef.DbType.XML -> new IndexDef((Set<QNm>)ImmutableSet.of(), (Set<QNm>)ImmutableSet.of(), 4 + indexDefNo, dbType);
        };
    }

    public static IndexDef createFilteredNameIdxDef(Set<QNm> excluded, int indexDefNo, IndexDef.DbType dbType) {
        return switch (dbType) {
            default -> throw new MatchException(null, null);
            case IndexDef.DbType.JSON -> new IndexDef((Set<QNm>)ImmutableSet.of(), excluded, 1 + indexDefNo, dbType);
            case IndexDef.DbType.XML -> new IndexDef((Set<QNm>)ImmutableSet.of(), excluded, 4 + indexDefNo, dbType);
        };
    }

    public static IndexDef createSelectiveNameIdxDef(Set<QNm> included, int indexDefNo, IndexDef.DbType dbType) {
        return switch (dbType) {
            default -> throw new MatchException(null, null);
            case IndexDef.DbType.JSON -> new IndexDef(included, (Set<QNm>)ImmutableSet.of(), 1 + indexDefNo, dbType);
            case IndexDef.DbType.XML -> new IndexDef(included, (Set<QNm>)ImmutableSet.of(), 4 + indexDefNo, dbType);
        };
    }
}

