/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index;

import com.google.common.collect.AbstractIterator;
import io.sirix.index.Filter;
import io.sirix.index.redblacktree.RBNodeKey;
import io.sirix.index.redblacktree.RBTreeReader;
import io.sirix.index.redblacktree.keyvalue.NodeReferences;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public final class IndexFilterAxis<K extends Comparable<? super K>>
extends AbstractIterator<NodeReferences> {
    private final RBTreeReader<K, NodeReferences> treeReader;
    private final Iterator<RBNodeKey<K>> iter;
    private final Set<? extends Filter> filter;

    public IndexFilterAxis(RBTreeReader<K, NodeReferences> treeReader, Iterator<RBNodeKey<K>> iter, Set<? extends Filter> filter) {
        this.treeReader = Objects.requireNonNull(treeReader);
        this.iter = Objects.requireNonNull(iter);
        this.filter = Objects.requireNonNull(filter);
    }

    protected NodeReferences computeNext() {
        while (this.iter.hasNext()) {
            Filter filter;
            RBNodeKey<K> node = this.iter.next();
            boolean filterResult = true;
            Iterator<? extends Filter> iterator = this.filter.iterator();
            while (iterator.hasNext() && (filterResult = (filter = iterator.next()).filter(node))) {
            }
            if (!filterResult) continue;
            this.treeReader.moveTo(node.getValueNodeKey());
            assert (this.treeReader.getCurrentNodeAsRBNodeValue() != null);
            return this.treeReader.getCurrentNodeAsRBNodeValue().getValue();
        }
        return (NodeReferences)this.endOfData();
    }
}

