/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index;

import java.util.HashMap;
import java.util.Map;

public enum IndexType {
    REVISIONS(0),
    DOCUMENT(1),
    CHANGED_NODES(2),
    RECORD_TO_REVISIONS(3),
    PATH_SUMMARY(4),
    PATH(5),
    CAS(6),
    NAME(7),
    DEWEYID_TO_RECORDID(8);

    private final byte id;
    private static final Map<Byte, IndexType> INSTANCEFORID;

    private IndexType(byte id) {
        this.id = id;
    }

    public byte getID() {
        return this.id;
    }

    public static IndexType getType(byte id) {
        IndexType indexType = INSTANCEFORID.get(id);
        if (indexType == null) {
            throw new IllegalStateException();
        }
        return indexType;
    }

    static {
        INSTANCEFORID = new HashMap<Byte, IndexType>();
        for (IndexType indexType : IndexType.values()) {
            INSTANCEFORID.put(indexType.id, indexType);
        }
    }
}

