/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index;

import com.google.common.base.Preconditions;
import io.brackit.query.atomic.QNm;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.Stream;
import io.brackit.query.jdm.Type;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.node.parser.FragmentHelper;
import io.brackit.query.util.path.Path;
import io.brackit.query.util.path.PathException;
import io.sirix.index.IndexDef;
import io.sirix.index.IndexType;
import io.sirix.index.Materializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.index.qual.NonNegative;

public final class Indexes
implements Materializable {
    public static final QNm INDEXES_TAG = new QNm("indexes");
    private final Set<IndexDef> indexes = new HashSet<IndexDef>();

    public synchronized Set<IndexDef> getIndexDefs() {
        return new HashSet<IndexDef>(this.indexes);
    }

    public synchronized IndexDef getIndexDef(@NonNegative int indexNo, IndexType type) {
        Preconditions.checkArgument((indexNo >= 0 ? 1 : 0) != 0, (Object)"indexNo must be >= 0!");
        for (IndexDef sid : this.indexes) {
            if (sid.getID() != indexNo || sid.getType() != type) continue;
            return sid;
        }
        return null;
    }

    @Override
    public synchronized void init(Node<?> root) throws DocumentException {
        QNm name = root.getName();
        if (!INDEXES_TAG.equals((Object)name)) {
            throw new DocumentException("Expected tag '%s' but found '%s'", new Object[]{INDEXES_TAG, name});
        }
        try (Stream children = root.getChildren();){
            Node child;
            while ((child = (Node)children.next()) != null) {
                QNm childName = child.getName();
                if (!childName.equals((Object)IndexDef.INDEX_TAG)) {
                    throw new DocumentException("Expected tag '%s' but found '%s'", new Object[]{IndexDef.INDEX_TAG, childName});
                }
                Node dbTypeAttrNode = child.getAttribute(new QNm("dbType"));
                Optional<IndexDef.DbType> dbType = IndexDef.DbType.ofString(dbTypeAttrNode.atomize().asStr().toString());
                IndexDef indexDefinition = new IndexDef(dbType.orElseThrow(() -> new DocumentException("DB type not found.", new Object[0])));
                indexDefinition.init(child);
                this.indexes.add(indexDefinition);
            }
        }
    }

    @Override
    public synchronized Node<?> materialize() throws DocumentException {
        FragmentHelper helper = new FragmentHelper();
        helper.openElement(INDEXES_TAG);
        for (IndexDef idxDef : this.indexes) {
            helper.insert(idxDef.materialize());
        }
        helper.closeElement();
        return helper.getRoot();
    }

    public synchronized void add(IndexDef indexDefinition) {
        this.indexes.add(indexDefinition);
    }

    public synchronized void removeIndex(@NonNegative int indexID) {
        Preconditions.checkArgument((indexID >= 0 ? 1 : 0) != 0, (Object)"indexID must be >= 0!");
        for (IndexDef indexDef : this.indexes) {
            if (indexDef.getID() != indexID) continue;
            this.indexes.remove(indexDef);
            return;
        }
    }

    public Optional<IndexDef> findPathIndex(Path<QNm> path) throws DocumentException {
        Objects.requireNonNull(path);
        try {
            for (IndexDef index : this.indexes) {
                if (!index.isPathIndex() || !this.checkIfAPathMatches(path, index)) continue;
                return Optional.of(index);
            }
            return Optional.empty();
        }
        catch (PathException e) {
            throw new DocumentException((Throwable)e);
        }
    }

    private boolean checkIfAPathMatches(Path<QNm> path, IndexDef index) {
        if (index.getPaths().isEmpty()) {
            return true;
        }
        for (Path<QNm> indexedPath : index.getPaths()) {
            if (!indexedPath.matches(path)) continue;
            return true;
        }
        return false;
    }

    public Optional<IndexDef> findCASIndex(Path<QNm> path, Type type) throws DocumentException {
        Objects.requireNonNull(path);
        try {
            for (IndexDef index : this.indexes) {
                if (!index.isCasIndex() || !index.getContentType().equals((Object)type) || !this.checkIfAPathMatches(path, index)) continue;
                return Optional.of(index);
            }
            return Optional.empty();
        }
        catch (PathException e) {
            throw new DocumentException((Throwable)e);
        }
    }

    public Optional<IndexDef> findNameIndex(QNm ... names) throws DocumentException {
        Objects.requireNonNull(names);
        block0: for (IndexDef index : this.indexes) {
            if (!index.isNameIndex()) continue;
            Set<QNm> incl = index.getIncluded();
            Set<QNm> excl = index.getExcluded();
            if (names.length == 0 && incl.isEmpty() && excl.isEmpty()) {
                return Optional.of(index);
            }
            for (QNm name : names) {
                if (!incl.isEmpty() && !incl.contains(name) || !excl.isEmpty() && excl.contains(name)) continue block0;
            }
            return Optional.of(index);
        }
        return Optional.empty();
    }

    public int getNrOfIndexDefsWithType(IndexType type) {
        Objects.requireNonNull(type);
        int nr = 0;
        for (IndexDef index : this.indexes) {
            if (index.getType() != type) continue;
            ++nr;
        }
        return nr;
    }
}

