/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.art;

import io.sirix.index.art.AscendingSubMap;
import io.sirix.index.art.BinaryComparable;
import io.sirix.index.art.BinaryComparableUtils;
import io.sirix.index.art.DescendingKeyIterator;
import io.sirix.index.art.DescendingSubMap;
import io.sirix.index.art.EntryIterator;
import io.sirix.index.art.EntrySet;
import io.sirix.index.art.InnerNode;
import io.sirix.index.art.KeyIterator;
import io.sirix.index.art.KeySet;
import io.sirix.index.art.LeafNode;
import io.sirix.index.art.Node;
import io.sirix.index.art.Node4;
import io.sirix.index.art.ValueIterator;
import io.sirix.index.art.Values;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;

public class AdaptiveRadixTree<K, V>
extends AbstractMap<K, V>
implements NavigableMap<K, V> {
    private final BinaryComparable<K> binaryComparable;
    private transient EntrySet<K, V> entrySet;
    private transient NavigableMap<K, V> descendingMap;
    private transient KeySet<K> navigableKeySet;
    private transient Collection<V> values;
    private transient int size = 0;
    private transient int modCount = 0;
    private Node root;

    int getModCount() {
        return this.modCount;
    }

    public AdaptiveRadixTree(BinaryComparable<K> binaryComparable) {
        Objects.requireNonNull(binaryComparable, "Specifying a BinaryComparable is necessary");
        this.binaryComparable = binaryComparable;
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException();
        }
        byte[] bytes = this.binaryComparable.get(key);
        if (this.root == null) {
            this.root = new LeafNode<K, V>(bytes, key, value);
            this.size = 1;
            ++this.modCount;
            return null;
        }
        return this.put(bytes, key, value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        LeafNode<K, V> e = this.getFirstEntry();
        while (e != null) {
            if (AdaptiveRadixTree.valEquals(value, e.getValue())) {
                return true;
            }
            e = AdaptiveRadixTree.successor(e);
        }
        return false;
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        LeafNode<K, V> p = this.getFirstEntry();
        Map.Entry<K, V> result = AdaptiveRadixTree.exportEntry(p);
        if (p != null) {
            this.deleteEntry(p);
        }
        return result;
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        LeafNode<K, V> p = this.getLastEntry();
        Map.Entry<K, V> result = AdaptiveRadixTree.exportEntry(p);
        if (p != null) {
            this.deleteEntry(p);
        }
        return result;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.root = null;
        ++this.modCount;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet<K, V> es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet(this));
    }

    @Override
    public Collection<V> values() {
        Collection<V> c = this.values;
        return c != null ? c : (this.values = new Values(this));
    }

    @Override
    public V get(Object key) {
        LeafNode<K, V> entry = this.getEntry(key);
        return entry == null ? null : (V)entry.getValue();
    }

    LeafNode<K, V> getEntry(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.root == null) {
            return null;
        }
        Object k = key;
        byte[] bytes = this.binaryComparable.get(k);
        return this.getEntry(this.root, bytes);
    }

    @Override
    public V remove(Object key) {
        LeafNode<K, V> p = this.getEntry(key);
        if (p == null) {
            return null;
        }
        V oldValue = p.getValue();
        this.deleteEntry(p);
        return oldValue;
    }

    private void pathCompressOnlyChild(Node4 toCompress) {
        Node onlyChild = toCompress.getChildren()[0];
        AdaptiveRadixTree.updateCompressedPathOfOnlyChild(toCompress, onlyChild);
        this.replace(toCompress.uplinkKey(), toCompress.parent(), onlyChild);
    }

    static void updateCompressedPathOfOnlyChild(Node4 toCompress, Node onlyChild) {
        assert (onlyChild != null);
        if (!(onlyChild instanceof LeafNode)) {
            byte partialKeyToOnlyChild = toCompress.getOnlyChildKey();
            InnerNode oc = (InnerNode)onlyChild;
            int toCopy = Math.min(8, toCompress.prefixLen + 1);
            int leftForMe = 8 - toCopy;
            int iHave = Math.min(8, oc.prefixLen);
            System.arraycopy(oc.prefixKeys, 0, oc.prefixKeys, toCopy, Math.min(leftForMe, iHave));
            int toCopyFromToCompress = Math.min(8, toCompress.prefixLen);
            System.arraycopy(toCompress.prefixKeys, 0, oc.prefixKeys, 0, toCopyFromToCompress);
            if (toCopyFromToCompress < 8) {
                oc.prefixKeys[toCopyFromToCompress] = partialKeyToOnlyChild;
            }
            oc.prefixLen += toCompress.prefixLen + 1;
        }
    }

    private LeafNode<K, V> getEntry(Node node, byte[] key) {
        int depth = 0;
        boolean skippedPrefix = false;
        while (true) {
            Node nextNode;
            if (node instanceof LeafNode) {
                int startFrom;
                LeafNode leaf = node;
                byte[] leafBytes = leaf.getKeyBytes();
                int n = startFrom = skippedPrefix ? 0 : depth;
                if (Arrays.equals(leafBytes, startFrom, leafBytes.length, key, startFrom, key.length)) {
                    return leaf;
                }
                return null;
            }
            InnerNode innerNode = (InnerNode)node;
            if (key.length < depth + innerNode.prefixLen) {
                return null;
            }
            if (innerNode.prefixLen <= 8) {
                for (int i = 0; i < innerNode.prefixLen; ++i) {
                    if (innerNode.prefixKeys[i] == key[depth + i]) continue;
                    return null;
                }
            } else {
                skippedPrefix = true;
            }
            if ((depth += innerNode.prefixLen) == key.length) {
                nextNode = innerNode.getLeaf();
                if (!skippedPrefix) {
                    return nextNode;
                }
            } else {
                nextNode = innerNode.findChild(key[depth]);
                ++depth;
            }
            if (nextNode == null) {
                return null;
            }
            node = nextNode;
        }
    }

    static int comparePessimisticCompressedPath(InnerNode node, byte[] key, int depth) {
        byte[] prefix = node.prefixKeys;
        int upperLimitForPessimisticMatch = Math.min(8, node.prefixLen);
        return AdaptiveRadixTree.compare(prefix, 0, upperLimitForPessimisticMatch, key, depth, Math.min(depth + upperLimitForPessimisticMatch, key.length));
    }

    private static int compareOptimisticCompressedPath(InnerNode node, byte[] key, int depth) {
        int result = AdaptiveRadixTree.comparePessimisticCompressedPath(node, key, depth);
        if (result != 0 || node.prefixLen <= 8) {
            return result;
        }
        byte[] leafBytes = AdaptiveRadixTree.getFirstEntry(node).getKeyBytes();
        return AdaptiveRadixTree.compare(leafBytes, depth + 8, depth + node.prefixLen, key, depth + 8, Math.min(depth + node.prefixLen, key.length));
    }

    void replace(int depth, byte[] key, InnerNode prevDepth, Node replaceWith) {
        if (prevDepth == null) {
            assert (depth == 0);
            this.root = replaceWith;
            Node.replaceUplink(null, this.root);
        } else {
            assert (depth > 0);
            prevDepth.replace(key[depth - 1], replaceWith);
        }
    }

    private void replace(byte partialKey, InnerNode prevDepth, Node replaceWith) {
        if (prevDepth == null) {
            this.root = replaceWith;
            Node.replaceUplink(null, this.root);
        } else {
            prevDepth.replace(partialKey, replaceWith);
        }
    }

    private V put(byte[] keyBytes, K key, V value) {
        byte partialKey;
        InnerNode innerNode;
        int depth = 0;
        InnerNode prevDepth = null;
        Node node = this.root;
        while (true) {
            if (node instanceof LeafNode) {
                LeafNode leaf = (LeafNode)node;
                Node pathCompressedNode = AdaptiveRadixTree.lazyExpansion(leaf, keyBytes, key, value, depth);
                if (pathCompressedNode == node) {
                    Object oldValue = leaf.getValue();
                    leaf.setValue(value);
                    return oldValue;
                }
                this.replace(depth, keyBytes, prevDepth, pathCompressedNode);
                ++this.size;
                ++this.modCount;
                return null;
            }
            innerNode = (InnerNode)node;
            int newDepth = this.matchCompressedPath(innerNode, keyBytes, key, value, depth, prevDepth);
            if (newDepth == -1) {
                ++this.size;
                ++this.modCount;
                return null;
            }
            if (keyBytes.length == newDepth) {
                LeafNode<?, ?> leaf = innerNode.getLeaf();
                Object oldValue = leaf.getValue();
                leaf.setValue(value);
                return (V)oldValue;
            }
            partialKey = keyBytes[newDepth];
            Node child = innerNode.findChild(partialKey);
            if (child == null) break;
            prevDepth = innerNode;
            depth = newDepth + 1;
            node = child;
        }
        LeafNode<K, V> leaf = new LeafNode<K, V>(keyBytes, key, value);
        if (innerNode.isFull()) {
            innerNode = innerNode.grow();
            this.replace(depth, keyBytes, prevDepth, innerNode);
        }
        innerNode.addChild(partialKey, leaf);
        ++this.size;
        ++this.modCount;
        return null;
    }

    private static <K, V> Node lazyExpansion(LeafNode<K, V> leaf, byte[] keyBytes, K key, V value, int depth) {
        int lcp = 0;
        byte[] leafKey = leaf.getKeyBytes();
        int end = Math.min(leafKey.length, keyBytes.length);
        while (depth < end && leafKey[depth] == keyBytes[depth]) {
            ++depth;
            ++lcp;
        }
        if (depth == keyBytes.length && depth == leafKey.length) {
            return leaf;
        }
        Node4 pathCompressedNode = new Node4();
        pathCompressedNode.prefixLen = lcp;
        int pessimisticLcp = Math.min(lcp, 8);
        System.arraycopy(keyBytes, depth - lcp, pathCompressedNode.prefixKeys, 0, pessimisticLcp);
        LeafNode<K, V> newLeaf = new LeafNode<K, V>(keyBytes, key, value);
        if (depth == keyBytes.length) {
            pathCompressedNode.setLeaf(newLeaf);
            pathCompressedNode.addChild(leafKey[depth], leaf);
        } else if (depth == leafKey.length) {
            pathCompressedNode.setLeaf(leaf);
            pathCompressedNode.addChild(keyBytes[depth], newLeaf);
        } else {
            pathCompressedNode.addChild(leafKey[depth], leaf);
            pathCompressedNode.addChild(keyBytes[depth], newLeaf);
        }
        return pathCompressedNode;
    }

    static void removeOptimisticLCPFromCompressedPath(InnerNode node, int depth, int lcp, byte[] leafBytes) {
        assert (lcp < node.prefixLen && lcp >= 8) : lcp;
        node.prefixLen = node.prefixLen - lcp - 1;
        int end = Math.min(8, node.prefixLen);
        System.arraycopy(leafBytes, depth + 1, node.prefixKeys, 0, end);
    }

    static void removePessimisticLCPFromCompressedPath(InnerNode node, int depth, int lcp) {
        assert (lcp < Math.min(8, node.prefixLen));
        if (node.prefixLen <= 8) {
            node.prefixLen = node.prefixLen - lcp - 1;
            System.arraycopy(node.prefixKeys, lcp + 1, node.prefixKeys, 0, node.prefixLen);
        } else {
            node.prefixLen = node.prefixLen - lcp - 1;
            byte[] leafBytes = AdaptiveRadixTree.getFirstEntry(node).getKeyBytes();
            int end = Math.min(8, node.prefixLen);
            System.arraycopy(leafBytes, depth + 1, node.prefixKeys, 0, end);
        }
    }

    private int matchCompressedPath(InnerNode node, byte[] keyBytes, K key, V value, int depth, InnerNode prevDepth) {
        InnerNode newNode;
        int lcp = 0;
        int end = Math.min(keyBytes.length - depth, Math.min(node.prefixLen, 8));
        while (lcp < end && keyBytes[depth] == node.prefixKeys[lcp]) {
            ++lcp;
            ++depth;
        }
        if (lcp == node.prefixLen) {
            if (depth == keyBytes.length && !node.hasLeaf()) {
                LeafNode<K, V> leafNode = new LeafNode<K, V>(keyBytes, key, value);
                node.setLeaf(leafNode);
                return -1;
            }
            return depth;
        }
        if (lcp == 8) {
            byte[] leafBytes = AdaptiveRadixTree.getFirstEntry(node).getKeyBytes();
            int leftToMatch = node.prefixLen - 8;
            end = Math.min(keyBytes.length, depth + leftToMatch);
            while (depth < end && keyBytes[depth] == leafBytes[depth]) {
                ++depth;
                ++lcp;
            }
            if (lcp == node.prefixLen) {
                if (depth == keyBytes.length && !node.hasLeaf()) {
                    LeafNode<K, V> leafNode = new LeafNode<K, V>(keyBytes, key, value);
                    node.setLeaf(leafNode);
                    return -1;
                }
                return depth;
            }
            newNode = AdaptiveRadixTree.branchOutOptimistic(node, keyBytes, key, value, lcp, depth, leafBytes);
        } else {
            newNode = AdaptiveRadixTree.branchOutPessimistic(node, keyBytes, key, value, lcp, depth);
        }
        this.replace(depth - lcp, keyBytes, prevDepth, newNode);
        return -1;
    }

    static <K, V> InnerNode branchOutOptimistic(InnerNode node, byte[] keyBytes, K key, V value, int lcp, int depth, byte[] leafBytes) {
        assert (lcp < node.prefixLen && lcp >= 8) : lcp + ", " + node.prefixLen;
        int initialDepth = depth - lcp;
        LeafNode<K, V> leafNode = new LeafNode<K, V>(keyBytes, key, value);
        Node4 branchOut = new Node4();
        branchOut.prefixLen = lcp;
        System.arraycopy(keyBytes, initialDepth, branchOut.prefixKeys, 0, 8);
        if (depth == keyBytes.length) {
            branchOut.setLeaf(leafNode);
        } else {
            branchOut.addChild(keyBytes[depth], leafNode);
        }
        branchOut.addChild(leafBytes[depth], node);
        AdaptiveRadixTree.removeOptimisticLCPFromCompressedPath(node, depth, lcp, leafBytes);
        return branchOut;
    }

    static <K, V> InnerNode branchOutPessimistic(InnerNode node, byte[] keyBytes, K key, V value, int lcp, int depth) {
        assert (lcp < node.prefixLen && lcp < 8);
        int initialDepth = depth - lcp;
        LeafNode<K, V> leafNode = new LeafNode<K, V>(keyBytes, key, value);
        Node4 branchOut = new Node4();
        branchOut.prefixLen = lcp;
        System.arraycopy(keyBytes, initialDepth, branchOut.prefixKeys, 0, lcp);
        if (depth == keyBytes.length) {
            branchOut.setLeaf(leafNode);
        } else {
            branchOut.addChild(keyBytes[depth], leafNode);
        }
        branchOut.addChild(node.prefixKeys[lcp], node);
        AdaptiveRadixTree.removePessimisticLCPFromCompressedPath(node, depth, lcp);
        return branchOut;
    }

    LeafNode<K, V> getFirstEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return AdaptiveRadixTree.getFirstEntry(this.root);
    }

    private static <K, V> LeafNode<K, V> getFirstEntry(Node startFrom) {
        Node node = startFrom;
        Node next = node.firstOrLeaf();
        while (next != null) {
            node = next;
            next = node.firstOrLeaf();
        }
        return (LeafNode)node;
    }

    LeafNode<K, V> getLastEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return AdaptiveRadixTree.getLastEntry(this.root);
    }

    private static <K, V> LeafNode<K, V> getLastEntry(Node startFrom) {
        Node node = startFrom;
        Node next = node.last();
        while (next != null) {
            node = next;
            next = node.last();
        }
        return (LeafNode)node;
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        return AdaptiveRadixTree.exportEntry(this.getLowerEntry(key));
    }

    @Override
    public K lowerKey(K key) {
        return AdaptiveRadixTree.keyOrNull(this.getLowerEntry(key));
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        return AdaptiveRadixTree.exportEntry(this.getFloorEntry(key));
    }

    @Override
    public K floorKey(K key) {
        return AdaptiveRadixTree.keyOrNull(this.getFloorEntry(key));
    }

    LeafNode<K, V> getLowerEntry(K k) {
        return this.getLowerOrFloorEntry(true, k);
    }

    LeafNode<K, V> getLowerEntry(byte[] k) {
        if (this.isEmpty()) {
            return null;
        }
        return this.getLowerOrFloorEntry(true, (K)k);
    }

    LeafNode<K, V> getFloorEntry(K k) {
        return this.getLowerOrFloorEntry(false, k);
    }

    LeafNode<K, V> getFloorEntry(byte[] k) {
        if (this.isEmpty()) {
            return null;
        }
        return this.getLowerOrFloorEntry(false, (K)k);
    }

    private LeafNode<K, V> getLowerOrFloorEntry(boolean lower, byte[] key) {
        int depth = 0;
        Node node = this.root;
        while (true) {
            if (node instanceof LeafNode) {
                LeafNode leafNode = (LeafNode)node;
                byte[] leafKey = leafNode.getKeyBytes();
                if (AdaptiveRadixTree.compare(key, depth, key.length, leafKey, depth, leafKey.length) >= (lower ? 1 : 0)) {
                    return leafNode;
                }
                return AdaptiveRadixTree.predecessor(leafNode);
            }
            InnerNode innerNode = (InnerNode)node;
            int compare = AdaptiveRadixTree.compareOptimisticCompressedPath((InnerNode)node, key, depth);
            if (compare < 0) {
                return AdaptiveRadixTree.getLastEntry(node);
            }
            if (compare > 0) {
                return AdaptiveRadixTree.predecessor(node);
            }
            if ((depth += innerNode.prefixLen) == key.length) {
                if (!lower && innerNode.hasLeaf()) {
                    return innerNode.getLeaf();
                }
                return AdaptiveRadixTree.predecessor(innerNode);
            }
            Node child = innerNode.floor(key[depth]);
            if (child == null) {
                return this.leafOrPredecessor(innerNode);
            }
            if (child.uplinkKey() != key[depth]) {
                return AdaptiveRadixTree.getLastEntry(child);
            }
            ++depth;
            node = child;
        }
    }

    private LeafNode<K, V> getLowerOrFloorEntry(boolean lower, K k) {
        if (this.isEmpty()) {
            return null;
        }
        byte[] key = this.binaryComparable.get(k);
        return this.getLowerOrFloorEntry(lower, (K)key);
    }

    private LeafNode<K, V> leafOrPredecessor(InnerNode innerNode) {
        if (innerNode.hasLeaf()) {
            return innerNode.getLeaf();
        }
        return AdaptiveRadixTree.predecessor(innerNode);
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        return AdaptiveRadixTree.exportEntry(this.getCeilingEntry(key));
    }

    int compare(K k1, byte[] k2Bytes) {
        byte[] k1Bytes = this.binaryComparable.get(k1);
        return AdaptiveRadixTree.compare(k1Bytes, 0, k1Bytes.length, k2Bytes, 0, k2Bytes.length);
    }

    static int compare(byte[] a, int aFrom, int aTo, byte[] b, int bFrom, int bTo) {
        int j;
        int i = aFrom;
        for (j = bFrom; i < aTo && j < bTo && a[i] == b[j]; ++i, ++j) {
        }
        if (i == aTo && j == bTo) {
            return 0;
        }
        if (i == aTo) {
            return -1;
        }
        if (j == bTo) {
            return 1;
        }
        return BinaryComparableUtils.unsigned(a[i]) < BinaryComparableUtils.unsigned(b[j]) ? -1 : 1;
    }

    @Override
    public K ceilingKey(K key) {
        return AdaptiveRadixTree.keyOrNull(this.getCeilingEntry(key));
    }

    static <K, V> K keyOrNull(Map.Entry<K, V> e) {
        return e == null ? null : (K)e.getKey();
    }

    LeafNode<K, V> getHigherEntry(K k) {
        return this.getHigherOrCeilEntry(false, k);
    }

    LeafNode<K, V> getHigherEntry(byte[] key) {
        if (this.isEmpty()) {
            return null;
        }
        return this.getHigherOrCeilEntry(false, (K)key);
    }

    LeafNode<K, V> getCeilingEntry(K k) {
        return this.getHigherOrCeilEntry(true, k);
    }

    LeafNode<K, V> getCeilingEntry(byte[] key) {
        if (this.isEmpty()) {
            return null;
        }
        return this.getHigherOrCeilEntry(true, (K)key);
    }

    private LeafNode<K, V> getHigherOrCeilEntry(boolean ceil, byte[] key) {
        int depth = 0;
        Node node = this.root;
        while (true) {
            if (node instanceof LeafNode) {
                LeafNode leafNode = (LeafNode)node;
                byte[] leafKey = leafNode.getKeyBytes();
                if (AdaptiveRadixTree.compare(key, depth, key.length, leafKey, depth, leafKey.length) < (ceil ? 1 : 0)) {
                    return leafNode;
                }
                return AdaptiveRadixTree.successor(leafNode);
            }
            InnerNode innerNode = (InnerNode)node;
            int compare = AdaptiveRadixTree.compareOptimisticCompressedPath(innerNode, key, depth);
            if (compare > 0) {
                return AdaptiveRadixTree.getFirstEntry(node);
            }
            if (compare < 0) {
                return AdaptiveRadixTree.successor(node);
            }
            if ((depth += innerNode.prefixLen) == key.length) {
                return ceil ? AdaptiveRadixTree.getFirstEntry(innerNode) : AdaptiveRadixTree.getFirstEntry(innerNode.first());
            }
            Node child = innerNode.ceil(key[depth]);
            if (child == null) {
                return AdaptiveRadixTree.successor(node);
            }
            if (child.uplinkKey() != key[depth]) {
                return AdaptiveRadixTree.getFirstEntry(child);
            }
            ++depth;
            node = child;
        }
    }

    private LeafNode<K, V> getHigherOrCeilEntry(boolean ceil, K k) {
        if (this.isEmpty()) {
            return null;
        }
        byte[] key = this.binaryComparable.get(k);
        return this.getHigherOrCeilEntry(ceil, (K)key);
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        return AdaptiveRadixTree.exportEntry(this.getHigherEntry(key));
    }

    @Override
    public K higherKey(K key) {
        return AdaptiveRadixTree.keyOrNull(this.getHigherOrCeilEntry(false, key));
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return AdaptiveRadixTree.exportEntry(this.getFirstEntry());
    }

    static <K, V> Map.Entry<K, V> exportEntry(Map.Entry<K, V> e) {
        return e == null ? null : new AbstractMap.SimpleImmutableEntry<K, V>(e);
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return AdaptiveRadixTree.exportEntry(this.getLastEntry());
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        NavigableMap<K, V> km = this.descendingMap;
        return km != null ? km : (this.descendingMap = new DescendingSubMap(this, true, null, true, true, null, true));
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        KeySet<K> nks = this.navigableKeySet;
        return nks != null ? nks : (this.navigableKeySet = new KeySet(this));
    }

    @Override
    public Set<K> keySet() {
        return this.navigableKeySet();
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return new AscendingSubMap(this, false, fromKey, fromInclusive, false, toKey, toInclusive);
    }

    @Override
    public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        return new AscendingSubMap(this, true, null, true, false, toKey, inclusive);
    }

    @Override
    public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        return new AscendingSubMap(this, false, fromKey, inclusive, true, null, true);
    }

    @Override
    public Comparator<? super K> comparator() {
        return null;
    }

    public BinaryComparable<K> binaryComparable() {
        return this.binaryComparable;
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap(fromKey, true, toKey, false);
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return this.headMap(toKey, false);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return this.tailMap(fromKey, true);
    }

    @Override
    public K firstKey() {
        return AdaptiveRadixTree.key(this.getFirstEntry());
    }

    static <K> K key(Map.Entry<K, ?> e) {
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e.getKey();
    }

    @Override
    public K lastKey() {
        return AdaptiveRadixTree.key(this.getLastEntry());
    }

    @Override
    public int size() {
        return this.size;
    }

    static <K, V> LeafNode<K, V> successor(Node node) {
        InnerNode uplink;
        while ((uplink = node.parent()) != null) {
            if (uplink.getLeaf() == node) {
                return AdaptiveRadixTree.getFirstEntry(uplink.first());
            }
            Node greater = uplink.greater(node.uplinkKey());
            if (greater != null) {
                return AdaptiveRadixTree.getFirstEntry(greater);
            }
            node = uplink;
        }
        return null;
    }

    static <K, V> LeafNode<K, V> predecessor(Node node) {
        InnerNode uplink;
        while ((uplink = node.parent()) != null) {
            if (uplink.getLeaf() == node) {
                node = uplink;
                continue;
            }
            Node lesser = uplink.lesser(node.uplinkKey());
            if (lesser != null) {
                return AdaptiveRadixTree.getLastEntry(lesser);
            }
            if (uplink.hasLeaf()) {
                return uplink.getLeaf();
            }
            node = uplink;
        }
        return null;
    }

    void deleteEntry(LeafNode<K, V> leaf) {
        --this.size;
        ++this.modCount;
        InnerNode parent = leaf.parent();
        if (parent == null) {
            this.root = null;
            return;
        }
        if (parent.getLeaf() == leaf) {
            parent.removeLeaf();
        } else {
            parent.removeChild(leaf.uplinkKey());
        }
        if (parent.shouldShrink()) {
            InnerNode newParent = parent.shrink();
            InnerNode grandParent = newParent.parent();
            this.replace(newParent.uplinkKey(), grandParent, newParent);
        } else if (parent.size() == 1 && !parent.hasLeaf()) {
            this.pathCompressOnlyChild((Node4)parent);
        } else if (parent.size() == 0) {
            assert (parent.hasLeaf());
            this.replace(parent.uplinkKey(), parent.parent(), parent.getLeaf());
        }
    }

    static boolean valEquals(Object o1, Object o2) {
        return Objects.equals(o1, o2);
    }

    Iterator<Map.Entry<K, V>> entryIterator() {
        return new EntryIterator<K, V>(this, this.getFirstEntry());
    }

    Iterator<V> valueIterator() {
        return new ValueIterator<K, V>(this, this.getFirstEntry());
    }

    Iterator<K> keyIterator() {
        return new KeyIterator<K, V>(this, this.getFirstEntry());
    }

    Iterator<K> descendingKeyIterator() {
        return new DescendingKeyIterator<K, V>(this, this.getLastEntry());
    }
}

