/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.art;

import io.sirix.index.art.BinaryComparable;
import io.sirix.index.art.BinaryComparableUtils;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class BinaryComparables {
    private static final BinaryComparable<Integer> INTEGER = key -> BinaryComparableUtils.unsigned(ByteBuffer.allocate(4).putInt((int)key).array());
    private static final BinaryComparable<Long> LONG = key -> BinaryComparableUtils.unsigned(ByteBuffer.allocate(8).putLong((long)key).array());
    private static final BinaryComparable<Short> SHORT = key -> BinaryComparableUtils.unsigned(ByteBuffer.allocate(2).putShort((short)key).array());
    private static final BinaryComparable<Byte> BYTE = key -> BinaryComparableUtils.unsigned(ByteBuffer.allocate(1).put((byte)key).array());

    private BinaryComparables() {
        throw new AssertionError();
    }

    public static BinaryComparable<Integer> forInteger() {
        return INTEGER;
    }

    public static BinaryComparable<Long> forLong() {
        return LONG;
    }

    public static BinaryComparable<Short> forShort() {
        return SHORT;
    }

    public static BinaryComparable<Byte> forByte() {
        return BYTE;
    }

    public static BinaryComparable<String> forString() {
        return String::getBytes;
    }

    public static BinaryComparable<String> forString(Charset charset) {
        return key -> key.getBytes(charset);
    }
}

