/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.art;

import io.sirix.index.art.LeafNode;
import io.sirix.index.art.Node;

abstract class InnerNode
extends Node {
    static final int PESSIMISTIC_PATH_COMPRESSION_LIMIT = 8;
    final byte[] prefixKeys;
    int prefixLen;
    short noOfChildren;
    final Node[] children;

    InnerNode(int size) {
        this.prefixKeys = new byte[8];
        this.children = new Node[size + 1];
    }

    InnerNode(InnerNode node, int size) {
        super(node);
        this.children = new Node[size + 1];
        this.noOfChildren = node.noOfChildren;
        this.prefixLen = node.prefixLen;
        this.prefixKeys = node.prefixKeys;
        this.children[size] = node.getLeaf();
        if (this.children[size] != null) {
            InnerNode.replaceUplink(this, this.children[size]);
        }
    }

    public void setLeaf(LeafNode<?, ?> leaf) {
        this.children[this.children.length - 1] = leaf;
        InnerNode.createUplink(this, leaf);
    }

    public void removeLeaf() {
        InnerNode.removeUplink(this.children[this.children.length - 1]);
        this.children[this.children.length - 1] = null;
    }

    public boolean hasLeaf() {
        return this.children[this.children.length - 1] != null;
    }

    public LeafNode<?, ?> getLeaf() {
        return (LeafNode)this.children[this.children.length - 1];
    }

    @Override
    public Node firstOrLeaf() {
        if (this.hasLeaf()) {
            return this.getLeaf();
        }
        return this.first();
    }

    Node[] getChildren() {
        return this.children;
    }

    public short size() {
        return this.noOfChildren;
    }

    abstract Node findChild(byte var1);

    abstract Node ceil(byte var1);

    abstract Node floor(byte var1);

    abstract void addChild(byte var1, Node var2);

    abstract void replace(byte var1, Node var2);

    abstract void removeChild(byte var1);

    abstract InnerNode grow();

    abstract boolean shouldShrink();

    abstract InnerNode shrink();

    abstract boolean isFull();

    abstract Node greater(byte var1);

    abstract Node lesser(byte var1);
}

