/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.art;

import io.sirix.index.art.BinaryComparableUtils;
import io.sirix.index.art.InnerNode;
import io.sirix.index.art.Node;
import io.sirix.index.art.Node4;
import io.sirix.index.art.Node48;
import java.util.Arrays;

class Node16
extends InnerNode {
    static final int NODE_SIZE = 16;
    private final byte[] keys = new byte[16];

    Node16(Node4 node) {
        super(node, 16);
        assert (node.isFull());
        byte[] keys = node.getKeys();
        Node[] child = node.getChildren();
        System.arraycopy(keys, 0, this.keys, 0, node.noOfChildren);
        System.arraycopy(child, 0, this.children, 0, node.noOfChildren);
        for (int i = 0; i < this.noOfChildren; ++i) {
            Node16.replaceUplink(this, this.children[i]);
        }
    }

    Node16(Node48 node48) {
        super(node48, 16);
        assert (node48.shouldShrink());
        byte[] keyIndex = node48.getKeyIndex();
        Node[] children = node48.getChildren();
        int j = 0;
        for (int i = 0; i < 256; ++i) {
            if (keyIndex[i] == -1) continue;
            this.children[j] = children[keyIndex[i]];
            this.keys[j] = BinaryComparableUtils.unsigned(this.children[j].uplinkKey());
            Node16.replaceUplink(this, this.children[j]);
            ++j;
        }
    }

    @Override
    public Node findChild(byte partialKey) {
        partialKey = BinaryComparableUtils.unsigned(partialKey);
        for (int i = 0; i < this.noOfChildren; ++i) {
            if (this.keys[i] != partialKey) continue;
            return this.children[i];
        }
        return null;
    }

    @Override
    public void addChild(byte partialKey, Node child) {
        assert (!this.isFull());
        byte unsignedPartialKey = BinaryComparableUtils.unsigned(partialKey);
        int index = Arrays.binarySearch(this.keys, 0, (int)this.noOfChildren, unsignedPartialKey);
        assert (index < 0);
        int insertionPoint = -(index + 1);
        assert (insertionPoint <= this.noOfChildren);
        for (int i = this.noOfChildren; i > insertionPoint; --i) {
            this.keys[i] = this.keys[i - 1];
            this.children[i] = this.children[i - 1];
        }
        this.keys[insertionPoint] = unsignedPartialKey;
        this.children[insertionPoint] = child;
        this.noOfChildren = (short)(this.noOfChildren + 1);
        Node16.createUplink(this, child, partialKey);
    }

    @Override
    public void replace(byte partialKey, Node newChild) {
        byte unsignedPartialKey = BinaryComparableUtils.unsigned(partialKey);
        int index = Arrays.binarySearch(this.keys, 0, (int)this.noOfChildren, unsignedPartialKey);
        assert (index >= 0);
        this.children[index] = newChild;
        Node16.createUplink(this, newChild, partialKey);
    }

    @Override
    public void removeChild(byte partialKey) {
        assert (!this.shouldShrink());
        byte unsignedPartialKey = BinaryComparableUtils.unsigned(partialKey);
        int index = Arrays.binarySearch(this.keys, 0, (int)this.noOfChildren, unsignedPartialKey);
        assert (index >= 0);
        Node16.removeUplink(this.children[index]);
        for (int i = index; i < this.noOfChildren - 1; ++i) {
            this.keys[i] = this.keys[i + 1];
            this.children[i] = this.children[i + 1];
        }
        this.children[this.noOfChildren - 1] = null;
        this.noOfChildren = (short)(this.noOfChildren - 1);
    }

    @Override
    public InnerNode grow() {
        assert (this.isFull());
        return new Node48(this);
    }

    @Override
    public boolean shouldShrink() {
        return this.noOfChildren == 4;
    }

    @Override
    public InnerNode shrink() {
        assert (this.shouldShrink()) : "Haven't crossed shrinking threshold yet";
        return new Node4(this);
    }

    @Override
    public Node first() {
        assert (this.noOfChildren > 4);
        return this.children[0];
    }

    @Override
    public Node last() {
        assert (this.noOfChildren > 4);
        return this.children[this.noOfChildren - 1];
    }

    @Override
    public Node ceil(byte partialKey) {
        partialKey = BinaryComparableUtils.unsigned(partialKey);
        for (int i = 0; i < this.noOfChildren; ++i) {
            if (this.keys[i] < partialKey) continue;
            return this.children[i];
        }
        return null;
    }

    @Override
    public Node greater(byte partialKey) {
        partialKey = BinaryComparableUtils.unsigned(partialKey);
        for (int i = 0; i < this.noOfChildren; ++i) {
            if (this.keys[i] <= partialKey) continue;
            return this.children[i];
        }
        return null;
    }

    @Override
    public Node lesser(byte partialKey) {
        partialKey = BinaryComparableUtils.unsigned(partialKey);
        for (int i = this.noOfChildren - 1; i >= 0; --i) {
            if (this.keys[i] >= partialKey) continue;
            return this.children[i];
        }
        return null;
    }

    @Override
    public Node floor(byte partialKey) {
        partialKey = BinaryComparableUtils.unsigned(partialKey);
        for (int i = this.noOfChildren - 1; i >= 0; --i) {
            if (this.keys[i] > partialKey) continue;
            return this.children[i];
        }
        return null;
    }

    @Override
    public boolean isFull() {
        return this.noOfChildren == 16;
    }

    byte[] getKeys() {
        return this.keys;
    }
}

