/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.art;

import io.sirix.index.art.BinaryComparableUtils;
import io.sirix.index.art.InnerNode;
import io.sirix.index.art.Node;
import io.sirix.index.art.Node16;

class Node4
extends InnerNode {
    static final int NODE_SIZE = 4;
    private final byte[] keys = new byte[4];

    Node4() {
        super(4);
    }

    Node4(Node16 node16) {
        super(node16, 4);
        assert (node16.shouldShrink());
        byte[] keys = node16.getKeys();
        Node[] child = node16.getChildren();
        System.arraycopy(keys, 0, this.keys, 0, node16.noOfChildren);
        System.arraycopy(child, 0, this.children, 0, node16.noOfChildren);
        for (int i = 0; i < this.noOfChildren; ++i) {
            Node4.replaceUplink(this, this.children[i]);
        }
    }

    @Override
    public Node findChild(byte partialKey) {
        partialKey = BinaryComparableUtils.unsigned(partialKey);
        for (int i = 0; i < this.noOfChildren; ++i) {
            if (this.keys[i] != partialKey) continue;
            return this.children[i];
        }
        return null;
    }

    @Override
    public void addChild(byte partialKey, Node child) {
        assert (!this.isFull());
        byte unsignedPartialKey = BinaryComparableUtils.unsigned(partialKey);
        for (int i = this.noOfChildren; i > 0 && unsignedPartialKey < this.keys[i - 1]; --i) {
            this.keys[i] = this.keys[i - 1];
            this.children[i] = this.children[i - 1];
        }
        this.keys[i] = unsignedPartialKey;
        this.children[i] = child;
        this.noOfChildren = (short)(this.noOfChildren + 1);
        Node4.createUplink(this, child, partialKey);
    }

    @Override
    public void replace(byte partialKey, Node newChild) {
        int index;
        byte unsignedPartialKey = BinaryComparableUtils.unsigned(partialKey);
        for (index = 0; index < this.noOfChildren && this.keys[index] != unsignedPartialKey; ++index) {
        }
        assert (index < this.noOfChildren) : "Partial key does not exist";
        this.children[index] = newChild;
        Node4.createUplink(this, newChild, partialKey);
    }

    @Override
    public void removeChild(byte partialKey) {
        int index;
        partialKey = BinaryComparableUtils.unsigned(partialKey);
        for (index = 0; index < this.noOfChildren && this.keys[index] != partialKey; ++index) {
        }
        assert (index < this.noOfChildren) : "Partial key does not exist";
        Node4.removeUplink(this.children[index]);
        for (int i = index; i < this.noOfChildren - 1; ++i) {
            this.keys[i] = this.keys[i + 1];
            this.children[i] = this.children[i + 1];
        }
        this.children[this.noOfChildren - 1] = null;
        this.noOfChildren = (short)(this.noOfChildren - 1);
    }

    @Override
    public InnerNode grow() {
        assert (this.isFull());
        return new Node16(this);
    }

    @Override
    public boolean shouldShrink() {
        return false;
    }

    @Override
    public InnerNode shrink() {
        throw new UnsupportedOperationException("Node4 is smallest node type");
    }

    @Override
    public Node first() {
        return this.children[0];
    }

    @Override
    public Node last() {
        return this.children[Math.max(0, this.noOfChildren - 1)];
    }

    @Override
    public Node ceil(byte partialKey) {
        partialKey = BinaryComparableUtils.unsigned(partialKey);
        for (int i = 0; i < this.noOfChildren; ++i) {
            if (this.keys[i] < partialKey) continue;
            return this.children[i];
        }
        return null;
    }

    @Override
    public Node greater(byte partialKey) {
        partialKey = BinaryComparableUtils.unsigned(partialKey);
        for (int i = 0; i < this.noOfChildren; ++i) {
            if (this.keys[i] <= partialKey) continue;
            return this.children[i];
        }
        return null;
    }

    @Override
    public Node lesser(byte partialKey) {
        partialKey = BinaryComparableUtils.unsigned(partialKey);
        for (int i = this.noOfChildren - 1; i >= 0; --i) {
            if (this.keys[i] >= partialKey) continue;
            return this.children[i];
        }
        return null;
    }

    @Override
    public Node floor(byte partialKey) {
        partialKey = BinaryComparableUtils.unsigned(partialKey);
        for (int i = this.noOfChildren - 1; i >= 0; --i) {
            if (this.keys[i] > partialKey) continue;
            return this.children[i];
        }
        return null;
    }

    @Override
    public boolean isFull() {
        return this.noOfChildren == 4;
    }

    byte[] getKeys() {
        return this.keys;
    }

    byte getOnlyChildKey() {
        assert (this.noOfChildren == 1);
        return BinaryComparableUtils.signed(this.keys[0]);
    }
}

