/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.art;

import io.sirix.index.art.BinaryComparableUtils;
import io.sirix.index.art.InnerNode;
import io.sirix.index.art.Node;
import io.sirix.index.art.Node16;
import io.sirix.index.art.Node256;
import java.util.Arrays;

class Node48
extends InnerNode {
    static final int NODE_SIZE = 48;
    static final int KEY_INDEX_SIZE = 256;
    private final byte[] keyIndex = new byte[256];
    static final byte ABSENT = -1;

    Node48(Node16 node) {
        super(node, 48);
        assert (node.isFull());
        Arrays.fill(this.keyIndex, (byte)-1);
        byte[] keys = node.getKeys();
        Node[] children = node.getChildren();
        for (int i = 0; i < 16; ++i) {
            byte key = BinaryComparableUtils.signed(keys[i]);
            int index = Byte.toUnsignedInt(key);
            this.keyIndex[index] = (byte)i;
            this.children[i] = children[i];
            Node48.replaceUplink(this, this.children[i]);
        }
    }

    Node48(Node256 node256) {
        super(node256, 48);
        assert (node256.shouldShrink());
        Arrays.fill(this.keyIndex, (byte)-1);
        Node[] children = node256.getChildren();
        int j = 0;
        for (int i = 0; i < 256; ++i) {
            if (children[i] == null) continue;
            this.keyIndex[i] = j;
            this.children[j] = children[i];
            Node48.replaceUplink(this, this.children[j]);
            j = (byte)(j + 1);
        }
        assert (j == 48);
    }

    @Override
    public Node findChild(byte partialKey) {
        byte index = this.keyIndex[Byte.toUnsignedInt(partialKey)];
        if (index == -1) {
            return null;
        }
        assert (index >= 0 && index <= 47);
        return this.children[index];
    }

    @Override
    public void addChild(byte partialKey, Node child) {
        int insertPosition;
        assert (!this.isFull());
        int index = Byte.toUnsignedInt(partialKey);
        assert (this.keyIndex[index] == -1);
        for (insertPosition = 0; this.children[insertPosition] != null && insertPosition < 48; insertPosition = (int)((byte)(insertPosition + 1))) {
        }
        this.children[insertPosition] = child;
        this.keyIndex[index] = insertPosition;
        this.noOfChildren = (short)(this.noOfChildren + 1);
        Node48.createUplink(this, child, partialKey);
    }

    @Override
    public void replace(byte partialKey, Node newChild) {
        byte index = this.keyIndex[Byte.toUnsignedInt(partialKey)];
        assert (index >= 0 && index <= 47);
        this.children[index] = newChild;
        Node48.createUplink(this, newChild, partialKey);
    }

    @Override
    public void removeChild(byte partialKey) {
        assert (!this.shouldShrink());
        int index = Byte.toUnsignedInt(partialKey);
        byte pos = this.keyIndex[index];
        assert (pos != -1);
        Node48.removeUplink(this.children[pos]);
        this.children[pos] = null;
        this.keyIndex[index] = -1;
        this.noOfChildren = (short)(this.noOfChildren - 1);
    }

    @Override
    public InnerNode grow() {
        assert (this.isFull());
        return new Node256(this);
    }

    @Override
    public boolean shouldShrink() {
        return this.noOfChildren == 16;
    }

    @Override
    public InnerNode shrink() {
        assert (this.shouldShrink());
        return new Node16(this);
    }

    @Override
    public Node first() {
        assert (this.noOfChildren > 16);
        int i = 0;
        while (this.keyIndex[i] == -1) {
            ++i;
        }
        return this.children[this.keyIndex[i]];
    }

    @Override
    public Node last() {
        assert (this.noOfChildren > 16);
        int i = 255;
        while (this.keyIndex[i] == -1) {
            --i;
        }
        return this.children[this.keyIndex[i]];
    }

    @Override
    public boolean isFull() {
        return this.noOfChildren == 48;
    }

    @Override
    public Node ceil(byte partialKey) {
        for (int i = Byte.toUnsignedInt(partialKey); i < 256; ++i) {
            if (this.keyIndex[i] == -1) continue;
            return this.children[this.keyIndex[i]];
        }
        return null;
    }

    @Override
    public Node greater(byte partialKey) {
        for (int i = Byte.toUnsignedInt(partialKey) + 1; i < 256; ++i) {
            if (this.keyIndex[i] == -1) continue;
            return this.children[this.keyIndex[i]];
        }
        return null;
    }

    @Override
    public Node lesser(byte partialKey) {
        for (int i = Byte.toUnsignedInt(partialKey) - 1; i >= 0; --i) {
            if (this.keyIndex[i] == -1) continue;
            return this.children[this.keyIndex[i]];
        }
        return null;
    }

    @Override
    public Node floor(byte partialKey) {
        for (int i = Byte.toUnsignedInt(partialKey); i >= 0; --i) {
            if (this.keyIndex[i] == -1) continue;
            return this.children[this.keyIndex[i]];
        }
        return null;
    }

    byte[] getKeyIndex() {
        return this.keyIndex;
    }
}

