/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.art;

import io.sirix.index.art.AdaptiveRadixTree;
import io.sirix.index.art.LeafNode;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

abstract class PrivateEntryIterator<K, V, T>
implements Iterator<T> {
    private final AdaptiveRadixTree<K, V> m;
    private LeafNode<K, V> next;
    private LeafNode<K, V> lastReturned;
    private int expectedModCount;

    PrivateEntryIterator(AdaptiveRadixTree<K, V> m, LeafNode<K, V> first) {
        this.expectedModCount = m.getModCount();
        this.lastReturned = null;
        this.next = first;
        this.m = m;
    }

    @Override
    public final boolean hasNext() {
        return this.next != null;
    }

    final LeafNode<K, V> nextEntry() {
        LeafNode<K, V> e = this.next;
        if (e == null) {
            throw new NoSuchElementException();
        }
        if (this.m.getModCount() != this.expectedModCount) {
            throw new ConcurrentModificationException();
        }
        this.next = AdaptiveRadixTree.successor(e);
        this.lastReturned = e;
        return e;
    }

    final LeafNode<K, V> prevEntry() {
        LeafNode<K, V> e = this.next;
        if (e == null) {
            throw new NoSuchElementException();
        }
        if (this.m.getModCount() != this.expectedModCount) {
            throw new ConcurrentModificationException();
        }
        this.next = AdaptiveRadixTree.predecessor(e);
        this.lastReturned = e;
        return e;
    }

    @Override
    public void remove() {
        if (this.lastReturned == null) {
            throw new IllegalStateException();
        }
        if (this.m.getModCount() != this.expectedModCount) {
            throw new ConcurrentModificationException();
        }
        this.m.deleteEntry(this.lastReturned);
        this.expectedModCount = this.m.getModCount();
        this.lastReturned = null;
    }
}

