/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.cas;

import com.google.common.collect.Iterators;
import io.brackit.query.atomic.Atomic;
import io.sirix.api.NodeCursor;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.api.PageTrx;
import io.sirix.index.ChangeListener;
import io.sirix.index.Filter;
import io.sirix.index.IndexDef;
import io.sirix.index.IndexFilterAxis;
import io.sirix.index.SearchMode;
import io.sirix.index.cas.CASFilter;
import io.sirix.index.cas.CASFilterRange;
import io.sirix.index.path.summary.PathSummaryReader;
import io.sirix.index.redblacktree.RBNodeKey;
import io.sirix.index.redblacktree.RBNodeValue;
import io.sirix.index.redblacktree.RBTreeReader;
import io.sirix.index.redblacktree.keyvalue.CASValue;
import io.sirix.index.redblacktree.keyvalue.NodeReferences;
import io.sirix.settings.Fixed;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public interface CASIndex<B, L extends ChangeListener, R extends NodeReadOnlyTrx & NodeCursor> {
    public B createBuilder(R var1, PageTrx var2, PathSummaryReader var3, IndexDef var4);

    public L createListener(PageTrx var1, PathSummaryReader var2, IndexDef var3);

    default public Iterator<NodeReferences> openIndex(PageReadOnlyTrx pageRtx, IndexDef indexDef, CASFilterRange filter) {
        RBTreeReader reader;
        RBTreeReader rBTreeReader = reader = RBTreeReader.getInstance(pageRtx.getResourceSession().getIndexCache(), pageRtx, indexDef.getType(), indexDef.getID());
        Objects.requireNonNull(rBTreeReader);
        RBTreeReader.RBNodeIterator iter = new RBTreeReader.RBNodeIterator(rBTreeReader, Fixed.DOCUMENT_NODE_KEY.getStandardProperty());
        return new IndexFilterAxis(reader, iter, (Set<? extends Filter>)((Set<Filter>)Set.of(filter)));
    }

    default public Iterator<NodeReferences> openIndex(PageReadOnlyTrx pageRtx, IndexDef indexDef, CASFilter filter) {
        LongSet pcrsAvailable;
        RBTreeReader<CASValue, NodeReferences> reader = RBTreeReader.getInstance(pageRtx.getResourceSession().getIndexCache(), pageRtx, indexDef.getType(), indexDef.getID());
        Set<Object> pcrsRequested = filter == null ? Set.of() : filter.getPCRs();
        LongSet longSet = pcrsAvailable = filter == null ? Collections.emptySet() : filter.getPCRCollector().getPCRsForPaths(indexDef.getPaths()).getPCRs();
        if (pcrsAvailable.size() <= 1 && pcrsRequested.size() == 1) {
            Atomic atomic = filter.getKey();
            long pcr = (Long)pcrsRequested.iterator().next();
            SearchMode mode = filter.getMode();
            CASValue value = new CASValue(atomic, atomic != null ? atomic.type() : null, pcr);
            if (mode == SearchMode.EQUAL) {
                Optional<RBNodeKey<CASValue>> optionalNode = reader.getCurrentNodeAsRBNodeKey(value, mode);
                return (Iterator)optionalNode.map(node -> {
                    reader.moveTo(node.getValueNodeKey());
                    RBNodeValue currentNodeAsRBNodeValue = reader.getCurrentNodeAsRBNodeValue();
                    if (!1.$assertionsDisabled && currentNodeAsRBNodeValue == null) {
                        throw new AssertionError();
                    }
                    return Iterators.forArray((Object[])new NodeReferences[]{(NodeReferences)currentNodeAsRBNodeValue.getValue()});
                }).orElse(Iterators.unmodifiableIterator(Collections.emptyIterator()));
            }
            Optional<RBNodeKey<CASValue>> optionalNode = reader.getCurrentNodeAsRBNodeKey(value, mode);
            return optionalNode.map(this.concatWithFilterAxis(filter, reader)).orElse(Collections.emptyIterator());
        }
        if (pcrsRequested.size() == 1) {
            Atomic atomic = filter.getKey();
            long pcr = (Long)pcrsRequested.iterator().next();
            SearchMode mode = filter.getMode();
            CASValue value = new CASValue(atomic, atomic.type(), pcr);
            if (mode == SearchMode.EQUAL) {
                Optional<RBNodeKey<CASValue>> optionalNode = reader.getCurrentNodeAsRBNodeKey(value, mode);
                return optionalNode.map(this.concatWithFilterAxis(filter, reader)).orElse(Collections.emptyIterator());
            }
            Optional<RBNodeKey<CASValue>> optionalNode = reader.getCurrentNodeAsRBNodeKey(value, SearchMode.EQUAL, Comparator.comparingLong(CASValue::getPathNodeKey));
            return optionalNode.map(this.findFirstNodeWithMatchingPCRAndAtomicValue(filter, reader, mode, value)).orElse(Collections.emptyIterator());
        }
        RBTreeReader<CASValue, NodeReferences> rBTreeReader = reader;
        Objects.requireNonNull(rBTreeReader);
        RBTreeReader.RBNodeIterator iter = new RBTreeReader.RBNodeIterator(rBTreeReader, Fixed.DOCUMENT_NODE_KEY.getStandardProperty());
        return new IndexFilterAxis(reader, iter, (Set<? extends Filter>)((Set<Filter>)(filter == null ? Set.of() : Set.of(filter))));
    }

    private Function<RBNodeKey<CASValue>, Iterator<NodeReferences>> findFirstNodeWithMatchingPCRAndAtomicValue(CASFilter filter, RBTreeReader<CASValue, NodeReferences> reader, SearchMode mode, CASValue value) {
        return node -> {
            Optional<RBNodeKey<CASValue>> firstFoundNode = reader.getCurrentNodeAsRBNodeKey(node.getNodeKey(), value, mode);
            return firstFoundNode.map(theNode -> {
                RBTreeReader rBTreeReader = reader;
                Objects.requireNonNull(rBTreeReader);
                RBTreeReader.RBNodeIterator iter = new RBTreeReader.RBNodeIterator(rBTreeReader, theNode.getNodeKey());
                return new IndexFilterAxis(reader, iter, (Set<? extends Filter>)((Set<Filter>)Set.of(filter)));
            }).orElse(Collections.emptyIterator());
        };
    }

    private Function<RBNodeKey<CASValue>, Iterator<NodeReferences>> concatWithFilterAxis(CASFilter filter, RBTreeReader<CASValue, NodeReferences> reader) {
        return node -> {
            RBTreeReader rBTreeReader = reader;
            Objects.requireNonNull(rBTreeReader);
            RBTreeReader.RBNodeIterator iter = new RBTreeReader.RBNodeIterator(rBTreeReader, node.getNodeKey());
            return new IndexFilterAxis(reader, iter, (Set<? extends Filter>)((Set<Filter>)Set.of(filter)));
        };
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

