/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.cas;

import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.jdm.Type;
import io.brackit.query.util.path.Path;
import io.sirix.access.trx.node.IndexController;
import io.sirix.exception.SirixIOException;
import io.sirix.exception.SirixRuntimeException;
import io.sirix.index.AtomicUtil;
import io.sirix.index.SearchMode;
import io.sirix.index.path.summary.PathSummaryReader;
import io.sirix.index.redblacktree.RBTreeReader;
import io.sirix.index.redblacktree.RBTreeWriter;
import io.sirix.index.redblacktree.keyvalue.CASValue;
import io.sirix.index.redblacktree.keyvalue.NodeReferences;
import io.sirix.node.interfaces.immutable.ImmutableNode;
import java.util.Optional;
import java.util.Set;

public final class CASIndexListener {
    private final RBTreeWriter<CASValue, NodeReferences> indexWriter;
    private final PathSummaryReader pathSummaryReader;
    private final Set<Path<QNm>> paths;
    private final Type type;

    public CASIndexListener(PathSummaryReader pathSummaryReader, RBTreeWriter<CASValue, NodeReferences> indexWriter, Set<Path<QNm>> paths, Type type) {
        this.pathSummaryReader = pathSummaryReader;
        this.indexWriter = indexWriter;
        this.paths = paths;
        this.type = type;
    }

    public void listen(IndexController.ChangeType type, ImmutableNode node, long pathNodeKey, Str value) {
        boolean hasMoved = this.pathSummaryReader.moveTo(pathNodeKey);
        assert (hasMoved);
        switch (type) {
            case INSERT: {
                if (!this.pathSummaryReader.getPCRsForPaths(this.paths).contains(pathNodeKey)) break;
                this.insert(node, pathNodeKey, value);
                break;
            }
            case DELETE: {
                if (!this.pathSummaryReader.getPCRsForPaths(this.paths).contains(pathNodeKey)) break;
                this.indexWriter.remove(new CASValue((Atomic)value, this.type, pathNodeKey), node.getNodeKey());
                break;
            }
        }
    }

    private void insert(ImmutableNode node, long pathNodeKey, Str value) throws SirixIOException {
        boolean isOfType = false;
        try {
            AtomicUtil.toType((Atomic)value, this.type);
            isOfType = true;
        }
        catch (SirixRuntimeException sirixRuntimeException) {
            // empty catch block
        }
        if (isOfType) {
            CASValue indexValue = new CASValue((Atomic)value, this.type, pathNodeKey);
            Optional<NodeReferences> textReferences = this.indexWriter.get(indexValue, SearchMode.EQUAL);
            if (textReferences.isPresent()) {
                this.setNodeReferences(node, new NodeReferences(textReferences.get().getNodeKeys()), indexValue);
            } else {
                this.setNodeReferences(node, new NodeReferences(), indexValue);
            }
        }
    }

    private void setNodeReferences(ImmutableNode node, NodeReferences references, CASValue indexValue) {
        this.indexWriter.index(indexValue, references.addNodeKey(node.getNodeKey()), RBTreeReader.MoveCursor.NO_MOVE);
    }
}

