/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.cas;

import io.brackit.query.atomic.QNm;
import io.brackit.query.jdm.Type;
import io.brackit.query.util.path.Path;
import io.sirix.access.DatabaseType;
import io.sirix.api.PageTrx;
import io.sirix.index.IndexDef;
import io.sirix.index.cas.CASIndexListener;
import io.sirix.index.path.summary.PathSummaryReader;
import io.sirix.index.redblacktree.RBTreeWriter;
import io.sirix.index.redblacktree.keyvalue.CASValue;
import io.sirix.index.redblacktree.keyvalue.NodeReferences;
import java.util.Objects;
import java.util.Set;

public final class CASIndexListenerFactory {
    private final DatabaseType databaseType;

    public CASIndexListenerFactory(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    public CASIndexListener create(PageTrx pageTrx, PathSummaryReader pathSummaryReader, IndexDef indexDef) {
        PathSummaryReader pathSummary = Objects.requireNonNull(pathSummaryReader);
        RBTreeWriter<CASValue, NodeReferences> avlTreeWriter = RBTreeWriter.getInstance(this.databaseType, pageTrx, indexDef.getType(), indexDef.getID());
        Type type = Objects.requireNonNull(indexDef.getContentType());
        Set<Path<QNm>> paths = Objects.requireNonNull(indexDef.getPaths());
        return new CASIndexListener(pathSummary, avlTreeWriter, paths, type);
    }
}

