/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.cas.json;

import io.sirix.access.trx.node.json.AbstractJsonNodeVisitor;
import io.sirix.api.json.JsonNodeReadOnlyTrx;
import io.sirix.api.visitor.VisitResult;
import io.sirix.index.cas.CASIndexBuilder;
import io.sirix.node.immutable.json.ImmutableArrayNode;
import io.sirix.node.immutable.json.ImmutableBooleanNode;
import io.sirix.node.immutable.json.ImmutableNumberNode;
import io.sirix.node.immutable.json.ImmutableObjectBooleanNode;
import io.sirix.node.immutable.json.ImmutableObjectKeyNode;
import io.sirix.node.immutable.json.ImmutableObjectNumberNode;
import io.sirix.node.immutable.json.ImmutableObjectStringNode;
import io.sirix.node.immutable.json.ImmutableStringNode;
import io.sirix.node.interfaces.immutable.ImmutableNode;

final class JsonCASIndexBuilder
extends AbstractJsonNodeVisitor {
    private final CASIndexBuilder indexBuilderDelegate;
    private final JsonNodeReadOnlyTrx rtx;

    JsonCASIndexBuilder(CASIndexBuilder indexBuilderDelegate, JsonNodeReadOnlyTrx rtx) {
        this.indexBuilderDelegate = indexBuilderDelegate;
        this.rtx = rtx;
    }

    @Override
    public VisitResult visit(ImmutableStringNode node) {
        long PCR = this.getPathClassRecord(node);
        return this.indexBuilderDelegate.process(node, PCR);
    }

    @Override
    public VisitResult visit(ImmutableObjectStringNode node) {
        long PCR = this.getPathClassRecord(node);
        return this.indexBuilderDelegate.process(node, PCR);
    }

    @Override
    public VisitResult visit(ImmutableBooleanNode node) {
        long PCR = this.getPathClassRecord(node);
        return this.indexBuilderDelegate.process(node, PCR);
    }

    @Override
    public VisitResult visit(ImmutableObjectBooleanNode node) {
        long PCR = this.getPathClassRecord(node);
        return this.indexBuilderDelegate.process(node, PCR);
    }

    @Override
    public VisitResult visit(ImmutableNumberNode node) {
        long PCR = this.getPathClassRecord(node);
        return this.indexBuilderDelegate.process(node, PCR);
    }

    @Override
    public VisitResult visit(ImmutableObjectNumberNode node) {
        long PCR = this.getPathClassRecord(node);
        return this.indexBuilderDelegate.process(node, PCR);
    }

    private long getPathClassRecord(ImmutableNode node) {
        this.rtx.moveTo(node.getParentKey());
        long pcr = this.rtx.isObjectKey() ? ((ImmutableObjectKeyNode)this.rtx.getNode()).getPathNodeKey() : (this.rtx.isArray() ? ((ImmutableArrayNode)this.rtx.getNode()).getPathNodeKey() : 0L);
        return pcr;
    }
}

