/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.cas.json;

import io.brackit.query.atomic.Str;
import io.sirix.access.trx.node.IndexController;
import io.sirix.index.ChangeListener;
import io.sirix.index.cas.CASIndexListener;
import io.sirix.node.interfaces.ValueNode;
import io.sirix.node.interfaces.immutable.ImmutableNode;
import io.sirix.node.json.BooleanNode;
import io.sirix.node.json.NumberNode;
import io.sirix.node.json.ObjectBooleanNode;
import io.sirix.node.json.ObjectNumberNode;

public final class JsonCASIndexListener
implements ChangeListener {
    private final CASIndexListener indexListenerDelegate;

    public JsonCASIndexListener(CASIndexListener indexListenerDelegate) {
        this.indexListenerDelegate = indexListenerDelegate;
    }

    @Override
    public void listen(IndexController.ChangeType type, ImmutableNode node, long pathNodeKey) {
        switch (node.getKind()) {
            case STRING_VALUE: 
            case OBJECT_STRING_VALUE: {
                ValueNode valueNode = (ValueNode)node;
                this.indexListenerDelegate.listen(type, valueNode, pathNodeKey, new Str(valueNode.getValue()));
                break;
            }
            case BOOLEAN_VALUE: {
                this.indexListenerDelegate.listen(type, node, pathNodeKey, new Str(String.valueOf(((BooleanNode)node).getValue())));
                break;
            }
            case OBJECT_BOOLEAN_VALUE: {
                this.indexListenerDelegate.listen(type, node, pathNodeKey, new Str(String.valueOf(((ObjectBooleanNode)node).getValue())));
                break;
            }
            case NUMBER_VALUE: {
                this.indexListenerDelegate.listen(type, node, pathNodeKey, new Str(String.valueOf(((NumberNode)node).getValue())));
                break;
            }
            case OBJECT_NUMBER_VALUE: {
                this.indexListenerDelegate.listen(type, node, pathNodeKey, new Str(String.valueOf(((ObjectNumberNode)node).getValue())));
            }
        }
    }
}

